.TH Dispatcher 3I "21 December 1990" "InterViews" "InterViews Reference Manual"
.SH NAME
Dispatcher \- wait on multiple file descriptors until a condition occurs
.SH SYNOPSIS
.B #include <Dispatch/dispatcher.h>
.SH DESCRIPTION
Conceptually, the dispatcher plays the role of detecting new data on
multiple input file descriptors and dispatching the data to the
appropriate iohandlers.  The dispatcher also notifies iohandlers of
expired timers.  Notification of either an I/O condition or an expired
timer occurs by calling one of the iohandler's virtual functions (see
IOHandler(3I)).  Since a program needs only one instance of
Dispatcher, a static member function is provided to create that
instance if necessary and return it.
.SH PUBLIC OPERATIONS
.TP
.B "enum DispatcherMask { ReadMask, WriteMask, ExceptMask }"
.ns
.TP
.B "virtual IOHandler* handler(int fd, DispatcherMask)"
.ns
.TP
.B "virtual void link(int fd, DispatcherMask, IOHandler*)"
.ns
.TP
.B "virtual void unlink(int fd)"
Return a file descriptor's iohandler, link a file descriptor to an
iohandler, or unlink a file descriptor from its iohandlers.  The
DispatcherMask describes the I/O condition that the iohandler is
interested in, such as whether the file descriptor has new data
available for reading.  If the I/O condition occurs, the iohandler
will be expected to read data from the file descriptor, write data to
the file descriptor, or handle the exception depending on the I/O
condition.
.TP
.B "virtual void startTimer(long sec, long usec, IOHandler*)"
.ns
.TP
.B "virtual void stopTimer(IOHandler*)"
Attach an iohandler to a timer or remove a timer before it expires.  A
timer expires after the given number of seconds and microseconds have
elapsed.  If a timer expires, the dispatcher will notify the attached
iohandler.  Timers will not expire until the program calls either
variant of Dispatcher::dispatch.
.TP
.B "virtual void dispatch()"
.ns
.TP
.B "virtual boolean dispatch(long& sec, long& usec)"
With no arguments, block indefinitely until an I/O condition occurs or
a timer expires and then notify the attached iohandler.  With two
arguments, block no longer than the given number of seconds and
microseconds.  If both numbers are zero, the function will return
immediately after checking all file descriptors and timers.  The
return value will be true if an I/O condition caused the function to
return and false if the function returned because a timer expired or
it exceeded the given poll time.  The function will decrease the given
poll time by the amount of time it spent blocking.
.TP
.B "static Dispatcher& instance()"
.ns
.TP
.B "static void instance(Dispatcher*)"
With no arguments, create an instance of Dispatcher if it doesn't
already exist and return it.  With an argument, set the instance of
Dispatcher that will be used throughout the program.
.SH SEE ALSO
select(2), IOHandler(3I)
