// adjtext.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include <InterViews/perspective.h>
#include <InterViews/shape.h>
#include "adjtext.h"
#include "query.h"
#include "range.h"

AdjustableText::AdjustableText(ButtonState *st, const char *samp,
		QueryValue *value) : TextInput(st, samp, value) {
	initialize();
}

AdjustableText::AdjustableText(const char* name, ButtonState *st,
	const char *samp, QueryValue *value) : TextInput(name, st, samp, value) {
	initialize();
}

void
AdjustableText::initialize() {
	perspective = new Perspective;
	perspective->Init(0, 0, 1, 1);
	perspective->curwidth = perspective->curheight = 1;
}

AdjustableText::~AdjustableText() {
}

void
AdjustableText::Reconfig() {
	TextInput::Reconfig();
	shape->Rigid(0, 0, 0, 0);	// disallow horiz changes as well
}

void
AdjustableText::Adjust(Perspective& np) {
	constrain(np);
	doAdjust(np);
	perspective->Update();
	Message(newString());
}

int
AdjustableText::lower() const { return perspective->x0; }

int
AdjustableText::upper() const {
	return perspective->x0 + perspective->width - 1;
}

int
AdjustableText::current() const { return perspective->curx; }

// only allows changes in cur{x,y}

void
AdjustableText::constrain(Perspective& np) {
	register Perspective* p = perspective;
	int newx = np.curx;
	int newy = np.cury;
	np = *p;
	p->curx = np.curx = max(lower(), min(upper(), newx));
	p->cury = np.cury = newy;
}

void
AdjustableText::setPerspectiveBounds(int lower, int upper) {
	perspective->x0 = lower;
	perspective->width = upper - lower + 1;
	perspective->Update();
}

void
AdjustableText::setPerspectiveCurrent(int current) {
	perspective->curx = max(lower(), min(upper(), current));
	perspective->Update();
}

// ********

AdjustableInteger::AdjustableInteger(ButtonState *s, QueryValue *v)
		: AdjustableNumber(s, "000000", v) {
	initialize();
}

void
AdjustableInteger::initialize() {
	setCurrent(Text());
}
	
void
AdjustableInteger::setBounds(const Range &bounds) {
	setPerspectiveBounds(bounds.intMin(), bounds.intMax());
}

void
AdjustableInteger::setCurrent(const char* str) {
	setPerspectiveCurrent((str && strlen(str)) ? atoi(str) : 0);
}

void
AdjustableInteger::doAdjust(Perspective &np) {
}

void
AdjustableInteger::doFinish() {
	setCurrent(Text());
	Message(newString());
}

const char *
AdjustableInteger::newString() {
	static char string[32];
	sprintf(string, "%d", current());
	return string;
}

