// channelgraph.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// A ChannelGraph controls the visual display of any one channel of a Data
// subclass object.  ChannelGraphs are tiled within a DataView subclass object
// (ChannelView) which coordinates their activities.

#ifndef CHANNELGRAPH_H
#ifdef __GNUG__
#pragma interface
#endif
#define CHANNELGRAPH_H

#include "graph.h"

class Brush;
class Controller;
class Selector;
class RubberText;
class GraphPlot;

class ChannelGraph : public Graph {
	typedef Graph Super;
public:
	ChannelGraph(Controller *c, Data *data, int chan, const Range& vertRange);
	ChannelGraph(Controller *c, Data *data, int chan);
	virtual ~ChannelGraph();
	// redefined InterViews methods
	redefined void Reconfig();
	redefined void Update();
	// new methods
	int currentChannel() { return channel; }
	virtual void setChannel(int channel);
	redefined const char* verticalScaleLabel();
	redefined boolean selected();
	redefined void togglePlotMode();

	redefined void setInsertPoint(int);
	redefined void setEditRegion(const Range &);
	redefined void unSelect();
protected:
	// redefined InterViews methods
	redefined void Redraw(Coord, Coord, Coord, Coord);

	redefined void setReferenceRange();
	redefined void select();
	redefined void selectAll();
	redefined void selectAllVisible();
	redefined void grab(Event &);
	redefined void track(Event &);
	redefined void processKeyEvent(Event &);
	redefined void setInsertCoord(Coord loc=0);
	redefined void setRegionCoords(const Range &);
	redefined void displayDataValue(boolean show);

	redefined boolean isViewChanged(Perspective &np);
protected:
	friend Selector;
	friend Controller;
	friend class DataView;
	friend class ChannelView;
	Brush *stdbrush, *dashbrush;
	GraphPlot* graphplot;		// waveform plot object
	Selector *selector;			// edit selection object
	RubberText* frameLabel;		// displays current frame value
	int channel;
	boolean useLines;
private:
	void Init();
	redefined void doResize() {	/* for later use */ }
	redefined void createPlot();
	redefined void loadPlot();
	redefined void doPlot();
};

#ifdef undef

class Painter;
class Canvas;

class Grid {
public:
	Grid(int nvlines, int nhlines);
	~Grid();
	void draw(Painter *, Canvas *);
protected:
	Brush *gridBrush;
	int nVertLines, nHorizLines;
};

#endif /* undef */

#endif /* GRAPH_H */
