// conv_config.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// Methods for protected RealConverter::ConfigRequester class and its subclasses
// These internal classes request user input for converter parameters such as
// playback level and output port.

#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "converter.h"
#include "query.h"
#include "request.h"
#include "sndconfig.h"

RealConverter::ConfigRequester::ConfigRequester(RealConverter* converter)
		: myConverter(converter) {}

const QueryInfo *
RealConverter::ConfigRequester::requestInfo() {
    static QueryLabelInfo labels[] = {
        { "Converter Settings: " }, { nil }
    };
    static QueryInfo info[] = {
        { labels, "", nil, nil },
        { nil }
    };
	return info;
}

void
RealConverter::ConfigRequester::configureRequest(Request& request) {
	request.appendValue(
		"Record Gain: ",
		myConverter->currentRecordLevel(),
		CharCheck::posIntsOnly
	);
	request.appendValue(
		"Playback Gain: ",
		myConverter->currentPlayLevel(),
		CharCheck::posIntsOnly
	);
}

boolean
RealConverter::ConfigRequester::setValues(Request& request) {
    QueryValue v[2];
	request.retrieveValues(v, 2);
	boolean status = myConverter->setRecordLevel(v[0]);
	return status && myConverter->setPlayLevel(v[1]);
}

#ifdef NeXT

#include "next_dac.h"

void
NextConverter::NextConfigRequester::configureRequest(Request& request) {
	ConfigRequester::configureRequest(request);
}

boolean
NextConverter::NextConfigRequester::setValues(Request& request) {
	return ConfigRequester::setValues(request);
}

#endif /* Next */

#ifdef SGI_DACS

#include "sgi_dac.h"

void
SGIConverter::SGIConfigRequester::configureRequest(Request& request) {
	ConfigRequester::configureRequest(request);
	SGIConverter* sc = (SGIConverter *) myConverter;
	request.appendChoice(
		"Input Source: ",
		"|microphone|line|digital|",
		int(sc->currentInputSource()),
		true
	);
}

boolean
SGIConverter::SGIConfigRequester::setValues(Request& request) {
	int status = ConfigRequester::setValues(request);
	if(status) {
		QueryChoice c;
		request.retrieveChoices(c);
		SGIConverter* sc = (SGIConverter *) myConverter;
		status = sc->setInputSource(InputSource(int(c)));	
	}
	return status;
}

#endif /* SGI_DACS */

#ifdef SPARC_DACS

#include "sun_dac.h"

void
SunConverter::SunConfigRequester::configureRequest(Request& request) {
	ConfigRequester::configureRequest(request);
	SunConverter* sc = (SunConverter *) myConverter;
	request.appendChoice(
		"Output Port: ",
		"|speaker|headphone|",
		int(sc->currentOutputPort()),
		true
	);
}

boolean
SunConverter::SunConfigRequester::setValues(Request& request) {
	int status = ConfigRequester::setValues(request);
	if(status) {
		QueryChoice c;
		request.retrieveChoices(c);
		SunConverter* sc = (SunConverter *) myConverter;
		status = sc->setOutputPort(OutputPort(int(c)));	
	}
	return status;
}

#endif /* SPARC_DACS */

#ifdef VOXWARE

#include "vw_converter.h"

void
VW_Converter::VW_ConfigRequester::configureRequest(Request& request) {
	ConfigRequester::configureRequest(request);
}

boolean
VW_Converter::VW_ConfigRequester::setValues(Request& request) {
	int status = ConfigRequester::setValues(request);
	return status;
}

#endif /* VOXWARE */
