// lpcdata.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Data subclass for storage and manipulation of LPC analysis data.

#ifndef LPCDATA_H
#ifdef __GNUG__
#pragma interface
#endif
#define LPCDATA_H

#include "framedata.h"

class DataFile;
class Header;
class Range;
class Controller;

class LPCData : public FrameData {
	typedef FrameData Super;
public:		// class methods
	static int defaultNumberOfPoles() { return default_NumberOfPoles; }
	static double defaultFrameRate() { return default_FrameRate; }
	static int setDefaultNumberOfPoles(int poles) {
		int old = default_NumberOfPoles; default_NumberOfPoles = poles;
		return old;
	}
	static double setDefaultFrameRate(double rate) {
		double old = default_FrameRate; default_FrameRate = rate; return old;
	}
public:		// object methods
	LPCData(int length=16, int npoles=0, int srate=0, double frate=0);
	redefined Data *newData();
	redefined Data *newData(int length);
	redefined Data *clone(const Range &);
	redefined Data *clone(const Range &, const Range &);

	redefined void information(Controller *);
	redefined void print(FILE *);
	redefined FileType fileType() const { return LPC_Data; }
	redefined const char *fileSuffix() const { return ".lpc"; }
	redefined Range limits(int chan=0, boolean real=false) const;
	void stabilizeFrames();
	boolean warpFrames(Data *);
	void mergePitchData(Data *);
	double weightedAveragePitch(double threshold = -1.0) const;
	double averagePitchDeviation(double threshold = -1.0) const;
	void scalePitchDeviation(double newDeviation, double threshold = -1.0,
		double pitchCutoff = 50.0);
	int nPoles() const { return channels() - 4; }

	// information methods for display objects
	redefined const char* windowClassName() const { return "LPCWindow"; }
	redefined const char* horizontalScaleModeAttribute() const {
		return "LPCWindowHorizontalScale";
	}
	redefined const char* channelDisplayAttribute() const {
		return "LPCWindowDisplayChannels";
	}
	redefined const char* defaultDirAttribute() const {
		return "DefaultLPCFileDir";
	}
	redefined const char* channelName(int chan) const;
protected:
	LPCData(const LPCData *l) : FrameData(l) {}
	LPCData(const LPCData *l, int newlen) : FrameData(l, newlen) {}
	LPCData(const LPCData *l, const Range &r) : FrameData(l, r) {} 
	LPCData(const LPCData *l, const Range &r, const Range &c)
		: FrameData(l, r, c) {} 
	redefined Header* createHeader(DataFile *, boolean isNew=false);
private:
	int stabilize(Data*);
	void warp(Data*, double, double*);
private:	// class methods
	enum Coeff_Type {
		Resid_Loc = 0, RMS_Loc = 1, Error_Loc = 2, Pitch_Loc = 3
	};
	static int factor(double*, long*, double*, double*, long*, long*, double*);
	static int dproot(long*, double*, double*, double*, long*, long*, double *);
	static int correct(double*, long*, double *);
	static int stabletest(double*, long*, long*);
private:	// class data
	static const int ArrSize;
	static int default_NumberOfPoles;
	static double default_FrameRate;
};

#endif
