// lpcfilter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// This class contains the low-level implementation of the all-pole filter
// used for LPC filtering and resynthesis.  It is used as one of the base
// classes in FormantFilter and FormantSynthesizer.  This class has intimate
// knowledge of the LPCData class, and acts as an iterator of the LPCData
// frames.

#ifndef LPCFILTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define LPCFILTER_H

#include "localdefs.h"

class Data;
class LPCData;

class LPC_Filter {
protected:
	LPC_Filter(LPCData *, int nsamps, int normalize=1);
	virtual ~LPC_Filter();
	boolean good() { return lpcdata != nil; }	// containing classes check this
	void initialize();
	void reset();
	float* getFrame(float* amp, float* error, float* pitch);
	double filter(float* coeffs, double sig);
	double warpFilter(float* coeffs, double sig);
	void advance();
	int lpcSamplingRate() { return sampleRate; }
	void setLPC(LPCData *);
	LPCData* getLPC() { return lpcdata; }
private:
	int needNewFrame() { return frameSamps == 0; }
	void cacheFrames(int current);
	float* interpolate(double fraction);
private:
	LPCData* lpcdata;
	Data* amplitudes;
	int doNormalize;
	int nPoles;
	int sampleRate;
	int counter;
	int oldFrame, lastFrame;
	double framesPerSamp;
	int totalSamps, sampsToGo;
	int frameSamps;
	float* pastValues;			// storage for allpole filter
	float* coeffArray;			// storage for actual frame
	float* currentArray;
	float* nextArray;			// these are cached for optimization
};

#endif
