// pchdata.c

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "controller.h"
#include "header.h"
#include "pchdata.h"
#include "request.h"

Data *
PCHData::newData() { return new PCHData(this); }

Data *
PCHData::newData(int length) { return new PCHData(this, length); }

Data *
PCHData::clone(const Range &r) { return new PCHData(this, r); }

Data *
PCHData::clone(const Range &r, const Range &c) { 
	return new PCHData(this, r, c);
}

void
PCHData::print(FILE* out) {
	int nframes = length();
	fprintf(out, "Pitch Data Dump\n");
	for(int i = 0; i < nframes; ++i) {
		fprintf(out, "Frame %d:  Pitch: %0.2f RMS Amp: %0.5f\n",
			i+1, get(i, 0), get(i, 1));
	}
	fflush(out);
}

void
PCHData::information(Controller *controller) {
	char str[128];
	AlertRequest request("Pitch Track File Information:");
	request.setBell(false);
	request.appendLabel("------------");
	request.appendLabel("Filename: ", controller->fileName());
	request.appendLabel("File Size (Mb): ",
		pstring(str, sizeInBytes()/1000000.0));
	request.appendLabel("NFrames: ", pstring(str, length()));
	request.appendLabel("Frame Rate: ", pstring(str, frameRate()));
	request.appendLabel("Frame Size (in samples): ",
		pstring(str, frameSize()));
	Range pitchRange = limits();
	request.appendLabel("Max Frequency: ", pstring(str, pitchRange.max()));
	request.appendLabel("Min Frequency: ", pstring(str, pitchRange.min()));
	request.appendLabel("Source Sound Duration (seconds): ",
		pstring(str, duration()));
	request.appendLabel("Source Sound Sample Rate: ",
		pstring(str, sRate()));
	controller->handleRequest(request);
}

const char *
PCHData::channelName(int chan) const {
	static char *chan_names[2] = { "Freq. in Hz", "RMS Amp" };
	return chan_names[chan];
}

// protected

Header *
PCHData::createHeader(DataFile *, boolean isNew) {
	// no header to write -- this is for future use
	return new PCHHeader(frameRate(), frameSize(), sRate(), duration());
}

void
PCHData::readFromHeader(Header *h) {
	// no header to read in pitch files as of now
	FrameData::readFromHeader(h);
	PCHHeader *hd = (PCHHeader *) h;
	framesize = hd->frameSize();
}

