// pulsegen.c

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "query.h"
#include "request.h"
#include "pulsegen.h"

double 
PulseGenerator::operator () (double input) {
	return (count++ % spacing == 0) ? amplitude : 0.0;
}

const QueryInfo *
PulseGenerator::requestInfo() {
	static QueryLabelInfo labelInfo[] = {
		{ "Pulse Signal Generator:" },
		{ nil }
	};	
	static QueryValueInfo valueInfo[] = {
		{ "Pulse Spacing (samples):", "2", CharCheck::posIntsOnly },
		{ "Gain Factor:", "1.00", CharCheck::numsOnly },
		{ nil }
	};	
	static QueryInfo info[] = {
		{ labelInfo, "", valueInfo, nil, defaultInputButtonInfo, Yes },
		{ nil }
	};
	return info;
}

boolean
PulseGenerator::setValues(Request& request) {
	const int nvals = 2;
	QueryValue vr[nvals];
	request.retrieveValues(vr, nvals);
	spacing = vr[0];
	amplitude = vr[1];
	return true;
}
