// pvocmodifier.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// DataModifier subclasses for processing phase vocoder data (see phasevoder.h,
// pvoceditor.h, and pvocdata.h).

#ifndef PVOCMODIFIER_H
#ifdef __GNUG__
#pragma interface
#endif
#define PVOCMODIFIER_H

#include "framemodifier.h"

class PvocModifier : public FrameModifier {
	typedef FrameModifier Super;
public:
	PvocModifier(Data* data) : FrameModifier(data) {}
protected:
	PvocData* pvTarget() { return (PvocData *) target(); }
private:
	friend class PvocData;
};

// abstract base class for classes that follow

class Controller;
class Envelope;

class SingleFactorModifier : public PvocModifier {
	typedef PvocModifier Super;
public:
	virtual double currentFactor();
protected:
	SingleFactorModifier(Data *);
	virtual ~SingleFactorModifier();
	redefined boolean configure(Controller *);
	redefined void initialize();
	redefined boolean setValues(Request& r);
	redefined void configureRequest(Request&);
	virtual boolean checkFactor() = 0;
protected:
	int upperBand;
	int lowerBand;
	int maxBand;
	double factor;
	Envelope* envelope;
};

class SpectrumTransposer : public SingleFactorModifier {
	typedef SingleFactorModifier Super;
public:
	SpectrumTransposer(Data* data) : SingleFactorModifier(data) {}
	static Modifier* create(class DataEditor*);
	redefined const char* message() { return "Transposing spectrum..."; }
	redefined int modifyFrame(Data* frame);
private:
	redefined const QueryInfo *requestInfo();
	redefined boolean checkFactor();
};

class SpectrumStretcher : public SingleFactorModifier {
	typedef SingleFactorModifier Super;
public:
	SpectrumStretcher(Data* data) : SingleFactorModifier(data) {}
	static Modifier* create(class DataEditor*);
	redefined const char* message() {
		return (factor > 1.0) ?
			"Stretching spectrum..." : "Shrinking spectrum...";
	}
	redefined int modifyFrame(Data* frame);
private:
	redefined const QueryInfo *requestInfo();
	redefined boolean checkFactor();
};

#endif
