// reson.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Wrappers for 2-pole and 2-pole-1-zero recursive filters.

#ifndef RESON_H
#ifdef __GNUG__
#pragma interface
#endif
#define RESON_H

#include "processfun.h"

class ResonFilter : public SimpleFunction {
public:
	virtual void set(double centerFreq, double bandWidth) = 0;
	redefined const char* message() { return "Filtering..."; }
protected:
	ResonFilter(Data* output, double fgain);
protected:
	double gain;
};

class Reson3 : public ResonFilter {
	typedef ResonFilter Super;
public:
	enum GainMode { Unity = 0x1, UnityRMS = 0x2, NoRescale = 0x4 };
	Reson3(Data* output, double centerFreq, double bandWidth, GainMode scale=UnityRMS);
	Reson3(Data* output) : ResonFilter(output, 1.0) {}
	redefined Modifier* create(class DataEditor*);
	redefined void set(double centerFreq, double bandWidth);
	redefined double operator () (double input);
	redefined void restoreState() { clear(); }
protected:
	redefined boolean setValues(Request &r);
private:
	redefined const QueryInfo *requestInfo();
	redefined void initialize() { clear();  Super::initialize(); }
	void clear();
private:
	double coef0, coef1, coef2;
	double past[2];
	GainMode scale;
};

class Reson4 : public ResonFilter {
	typedef ResonFilter Super;
public:
	Reson4(Data* output, double centerFreq, double bandWidth);
	virtual ~Reson4();
	redefined void set(double centerFreq, double bandWidth);
	redefined double operator () (double input);
	redefined void restoreState() { clear(); Super::initialize(); }
private:
	redefined void initialize() { clear(); }
	void clear();
private:
	double coef0, coef1, coef2, coef3;
	double inPast[2];
	double outPast[2];
};

#endif

