// delay.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// The Delay class is an implementation of a simple pipe delay with a transfer
// function f(x) = f(x-n), where 'n' is variable from 0 - whatever.

#ifndef DELAY_H
#ifdef __GNUG__
#pragma interface
#endif
#define DELAY_H

#include "localdefs.h"
#include "processfun.h"

class Delay : public SimpleFunction {
	typedef SimpleFunction Super;
public:
	Delay(Data* output, int nsamps);
	Delay(Data* output) : SimpleFunction(output),
		stack(nil), counter(0), stackSize(0), stackMax(0) {}
	static Modifier* create(class DataEditor*);
	virtual ~Delay();
	redefined double operator () (double input);
	redefined void restoreState();
	redefined const char* message() { return "Adding delay..."; }
	redefined Modifier* createUnDo();
protected:
	friend class CombFilter;
	redefined void initialize();
	redefined boolean setValues(Request &);
	int wrap(int val);
	void increment() { counter = (counter + 1) % stackSize; }
	void push(double top);
	double getPast(int delayed);
	double getPast(void);
private:
	redefined const QueryInfo *requestInfo();
	void clear();
private:
	double *stack;
	int counter;
	int stackSize;
	int stackMax;
};

inline int
Delay::wrap(int val) {
	return (val < 0) ? val + stackSize :
		(val >= stackSize) ? val - stackSize : val;
}

inline void
Delay::push(double top) { *(stack + counter) = top; }

inline double
Delay::getPast(int delayed) { return *(stack + wrap(counter - delayed)); }

inline double
Delay::getPast(void) { return *(stack + wrap(counter - stackMax)); }

#endif
