// modifier.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Modifier is the generic base class for all routines that modify the Data 
// or the View of that Data in any way involving user input.  The message()
// method provides a text string to be displayed during the modification
// process.  The createUnDo() method returns a pointer to an instance of a
// Modifier which will reverse the effects of this Modifier, or nil if this
// is not possible.  ModifierChain allows up to three Modifiers to be called
// in sequence.

#ifndef MODIFIER_H
#ifdef __GNUG__
#pragma interface
#endif
#define MODIFIER_H

#include "localdefs.h"
#include "requester.h"

class Modifier : public Requester {
public:
	Modifier() {}
	virtual int apply()=0;
	virtual const char* message() { return nil; }
	virtual Modifier* createUnDo() { return nil; }
};

class Controller;
struct QueryInfo;

class ModifierChain : public Modifier {
	typedef Modifier Super;
public:
	ModifierChain(Modifier* m1, Modifier* m2, Modifier* m3=nil);
	virtual ~ModifierChain();
	redefined boolean configure(Controller *);
	redefined int apply();
	redefined Modifier* createUnDo();
private:
	const QueryInfo* requestInfo() { return nil; }
private:
	class ModifierLink {
	public:
		ModifierLink(Modifier* m);
		~ModifierLink();
		Modifier* modifier;
		ModifierLink* next;
	};
	ModifierLink* list;
};

#endif

