// repclone.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "application.h"
#include "range.h"
#include "repclone.h"

void
Clone::changeNChans(int newchans) {
	int oldchans = cloneChans;
	double ratio = oldchans / double(newchans);
	cloneChans = newchans;
	cloneLen = int(cloneLen * ratio);
}

////////

CharRepClone::CharRepClone(CharDataRep *dr, const Range &selection, 
		const Range &chanrange) : CharDataRep(dr),
		Clone(dr, selection.intMin() < realLength() ? selection.size() : 0,
		chanrange.size()) {
	offsetPointer(
		getHandle(selection.intMin(), chanrange.intMin()) - arrayOffset()
	);
}

void
CharRepClone::valueRange(Range &r, int start, int end, int chfirst, int chlast, boolean real) const {
	if(real)
		master->valueRange(r, start, end, chfirst, chlast, real);
	else
		CharDataRep::valueRange(r, start, end, chfirst, chlast, real);
}

int
CharRepClone::changeLength(int newlen) {
	int oldlen = master->length();
	if(master->changeLength(newlen)) {
		int diff = master->length() - oldlen;
		len += diff;
		cloneLen += diff;
		return 1;
	}
	return 0;
}

void
CharRepClone::changeNChans(int newchans) {
	CharDataRep::changeNChans(newchans);
	Clone::changeNChans(newchans);
}

///////////

MuLawRepClone::MuLawRepClone(MuLawDataRep *dr, const Range &selection,
		const Range &chanrange) : MuLawDataRep(dr),
		Clone(dr, selection.intMin() < realLength() ? selection.size() : 0,
		chanrange.size()) {
	offsetPointer(
		getHandle(selection.intMin(), chanrange.intMin()) - arrayOffset()
	);
}

void
MuLawRepClone::valueRange(Range &r, int start, int end, int chfirst, int chlast, boolean real) const {
	if(real)
		master->valueRange(r, start, end, chfirst, chlast, real);
	else
		MuLawDataRep::valueRange(r, start, end, chfirst, chlast, real);
}

int
MuLawRepClone::changeLength(int newlen) {
	int oldlen = master->length();
	if(master->changeLength(newlen)) {
		int diff = master->length() - oldlen;
		len += diff;
		cloneLen += diff;
		return 1;
	}
	return 0;
}

void
MuLawRepClone::changeNChans(int newchans) {
	MuLawDataRep::changeNChans(newchans);
	Clone::changeNChans(newchans);
}

///////////

ShortRepClone::ShortRepClone(ShortDataRep *dr, const Range &selection,
	const Range &chanrange) : ShortDataRep(dr),
		Clone(dr, selection.intMin() < realLength() ? selection.size() : 0,
		chanrange.size()) {
	offsetPointer(
		getHandle(selection.intMin(), chanrange.intMin()) - arrayOffset()
	);
}

void
ShortRepClone::valueRange(Range &r, int start, int end, int chfirst, int chlast, boolean real) const {
	if(real)
		master->valueRange(r, start, end, chfirst, chlast, real);
	else
		ShortDataRep::valueRange(r, start, end, chfirst, chlast, real);
}

int
ShortRepClone::changeLength(int newlen) {
	int oldlen = master->length();
	if(master->changeLength(newlen)) {
		int diff = master->length() - oldlen;
		len += diff;
		cloneLen += diff;
		return 1;
	}
	return 0;
}

void
ShortRepClone::changeNChans(int newchans) {
	ShortDataRep::changeNChans(newchans);
	Clone::changeNChans(newchans);
}

///////////

FloatRepClone::FloatRepClone(FloatDataRep *dr, const Range &selection,
		const Range &chanrange) : FloatDataRep(dr),
		Clone(dr, selection.intMin() < realLength() ? selection.size() : 0,
		chanrange.size()) {
	offsetPointer(
		getHandle(selection.intMin(), chanrange.intMin()) - arrayOffset()
	);
}

void
FloatRepClone::valueRange(Range &r, int start, int end, int chfirst, int chlast, boolean real) const {
	if(real)
		master->valueRange(r, start, end, chfirst, chlast, real);
	else
		FloatDataRep::valueRange(r, start, end, chfirst, chlast, real);
}

int
FloatRepClone::changeLength(int newlen) {
	int oldlen = master->length();
	if(master->changeLength(newlen)) {
		int diff = master->length() - oldlen;
		len += diff;
		cloneLen += diff;
		return 1;
	}
	return 0;
}

void
FloatRepClone::changeNChans(int newchans) {
	FloatDataRep::changeNChans(newchans);
	Clone::changeNChans(newchans);
}

///////////

DoubleRepClone::DoubleRepClone(DoubleDataRep *dr, const Range &selection,
		const Range &chanrange) : DoubleDataRep(dr),
		Clone(dr, selection.intMin() < realLength() ? selection.size() : 0,
		chanrange.size()) {
	offsetPointer(
		getHandle(selection.intMin(), chanrange.intMin()) - arrayOffset()
	);
}

void
DoubleRepClone::valueRange(Range &r, int start, int end, int chfirst, int chlast, boolean real) const {
	if(real)
		master->valueRange(r, start, end, chfirst, chlast, real);
	else
		DoubleDataRep::valueRange(r, start, end, chfirst, chlast, real);
}

int
DoubleRepClone::changeLength(int newlen) {
	int oldlen = master->length();
	if(master->changeLength(newlen)) {
		int diff = master->length() - oldlen;
		len += diff;
		cloneLen += diff;
		return 1;
	}
	return 0;
}

void
DoubleRepClone::changeNChans(int newchans) {
	DoubleDataRep::changeNChans(newchans);
	Clone::changeNChans(newchans);
}
