// sun_dac.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// ConverterDevice subclass for built-in SPARC 8- or 16-bit D/A A/D converters.
// An environmental variable set by the user will determine which type of
// converter is available -- this saves us from needed two different objects.

#ifndef SUN_DAC_H
#ifdef __GNUG__
#pragma interface
#endif
#define SUN_DAC_H

#include "conv_device.h"
#include <multimedia/libaudio.h>
#include <poll.h>

class SunConverter : public ConverterDevice {
	typedef ConverterDevice Super;
public:
	enum InputPort { Mike = 0x1, Line = 0x2 };
	enum OutputPort { Speaker = 0x1, Headphone = 0x2 };
	SunConverter();
	virtual ~SunConverter();
	redefined int pause();
	redefined int resume();
	redefined int stop();
	redefined int currentRecordLevel();
	redefined int currentPlayLevel();
	redefined int setRecordLevel(int volume);
	redefined int setPlayLevel(int volume);
	redefined DataType bestPlayableType();
protected:
	redefined boolean isPlayableFormat(DataType type);
	redefined int doConfigure();
	redefined int writeSize();
	redefined int readSize();
	redefined void waitForDevice();
	redefined int waitForStop(StatusAction *);
	InputPort currentInputPort();
	int setInputPort(InputPort);
	OutputPort currentOutputPort();
	int setOutputPort(OutputPort);
	class SunConfigRequester : public RealConverter::ConfigRequester {
	public:
		SunConfigRequester(RealConverter* cvtr) : ConfigRequester(cvtr) {}
	protected:
		redefined void configureRequest(Request &);
		redefined boolean setValues(Request &);
	};
	friend void SunConfigRequester::configureRequest(Request &);
	friend boolean SunConfigRequester::setValues(Request &);
	redefined Requester* configRequester() {
		return new SunConfigRequester(this);
	}
private:
	int confirmDeviceType();
	void initialize();
	boolean getConfiguration(Audio_hdr *);
	boolean reconfigure(Audio_hdr*, Audio_hdr*);
	unsigned sampleEncoding();
	static boolean isSparc10() { return sparc_version >= 10; }
	static boolean isSparc20() { return sparc_version == 20; }
	SunConverter(const SunConverter &);
private:
	static struct pollfd pollStruct;
	static int sparc_version;
};

#endif
