// typeconvert.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// inline functions for converting between Data types and header formats

#ifndef TYPECONVERT_H
#define TYPECONVERT_H

#include "sndconfig.h"

inline DataType
format_to_type(int s) {
	return s==MULAW_FORMAT ? MuLawData 
	: s==SHORT_FORMAT ? ShortData 
	: s==FLOAT_FORMAT ? FloatData : NoData;
}

inline int
type_to_format(DataType t) {
	return (t==CharData) ? CHAR_FORMAT: (t==MuLawData) ? MULAW_FORMAT
	: (t==ShortData) ? SHORT_FORMAT
	: (t==FloatData) ? FLOAT_FORMAT : 0;
}

inline DataType
sampsize_to_type(int s) {
	return s==sizeof(char) ? MuLawData 
		: s==sizeof(short) ? ShortData : s==sizeof(float) ? FloatData
		: s==sizeof(double) ? DoubleData : NoData;
}

inline int
type_to_sampsize(DataType t) {
	return (t== CharData || t==MuLawData) ? 1 : (t==ShortData) ? 2
		: (t==FloatData) ? 4 : (t==DoubleData) ? 8 : 0;
}

#endif

