// vw_converter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifndef VW_CONVERTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define VW_CONVERTER_H

#include "conv_device.h"

class VW_Converter : public ConverterDevice {
	typedef ConverterDevice Super;
public:
	VW_Converter();
	virtual ~VW_Converter();
	redefined int pause();
	redefined int stop();
	redefined DataType bestPlayableType();
protected:
	redefined boolean isPlayableFormat(DataType type);
	redefined int doConfigure();					// hardware-specific
	redefined int checkChannels(int chans);
	redefined int writeSize();						// buffer size in bytes
	redefined int readSize();						// buffer size in bytes
	class VW_ConfigRequester : public RealConverter::ConfigRequester {
	public:
		VW_ConfigRequester(RealConverter* cnverter) : ConfigRequester(cnverter) {}
	protected:
		redefined void configureRequest(Request &);
		redefined boolean setValues(Request &);
	};
	friend void VW_ConfigRequester::configureRequest(Request &);
	friend boolean VW_ConfigRequester::setValues(Request &);
	redefined Requester* configRequester() {
		return nil; /* new VW_ConfigRequester(this); */
	}
private:
	VW_Converter(const VW_Converter &);
private:
	int audioBufferSize;
};

#endif
