// statuspanel.c

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "statuspanel.h"
#include "vmessage.h"
#include "localdefs.h"
#include <InterViews/box.h>
#include <InterViews/glue.h>

static char panel__tmpstr_array[64];	// ptr to this used by update methods

char *
StatusPanel::tempString = panel__tmpstr_array;

StatusPanel::StatusPanel(const char* label, const char* value) {
	init(label);
	updateValue(value);
}

StatusPanel::StatusPanel(const char* label, int value) {
	init(label);
	updateValue(value);
}

StatusPanel::StatusPanel(const char* label, double value) {
	init(label);
	updateValue(value);
}

void
StatusPanel::init(const char* label) {
	SetClassName("StatusPanel");
	myLabel = new VMessage("PanelMessage", label, Left, 3);
	myValue = new VMessage("PanelMessage", "000.000000", Left, 3);
	Insert(
		new HBox(
			new HGlue(3, 0, 0),
			myLabel,
			new HGlue(10, 0, hfil),
			myValue,
			new HGlue(3, 0, 0)
		)
	);
	Propagate(false);
}

void
StatusPanel::updateValue(const char* newvalue) {
	myValue->setText(newvalue);
}

void
StatusPanel::updateValue(int newvalue) {
	updateValue(toString(tempString, newvalue));
}

void
StatusPanel::updateValue(double newvalue) {
	updateValue(toString(tempString, newvalue));
}

void
StatusPanel::updateLabel(const char* newlabel) {
	myLabel->setText(newlabel);
}

