// z1lpf.cc

#include "z1lpf.h"

SPKitZ1LowPassFilter::SPKitZ1LowPassFilter()
{
    buf = 0;
    channelIndex = 0;
    g = 0.0;
}

SPKitZ1LowPassFilter::~SPKitZ1LowPassFilter()
{
    if (buf)
	delete [] buf;
}

SPKitError SPKitZ1LowPassFilter::setInput(SPKitProcessor* ip)
{
    SPKitProcessor::setInput(ip);

    buf = new SPKitSample[inputChannelCount];

    if (buf == 0)
	return -1;

    for (int i = 0; i < inputChannelCount; i++)
	buf[i] = 0.0;

    return 0;
}

SPKitZ1LowPassFilter::getSample(SPKitSample& outputSample)
{
    SPKitSample inputSample;

    if (!input->getSample(inputSample))
	return 0;
    
    outputSample = inputSample + buf[channelIndex] * g;

    buf[channelIndex++] = inputSample;

    channelIndex %= inputChannelCount;

    return 1;
}
