// allpassn.cc

#include <math.h>
#include "allpassn.h"

SPKitAllPassNetwork::SPKitAllPassNetwork()
{
    reverbTime = 2.0;
    delayTime = 0.006;
    g = 0.7;
}

SPKitAllPassNetwork::setInputAndDelayTime(SPKitProcessor *ip, SPKitFloat dt)
{
    delayTime = dt;
    
    mux1.setInput(ip);
    amp1.setInput(&mux1);
    amp1.setGain(-g);
    sum.setInput(&amp1);
    feedback.setInput(&mux1);
    delay.setInputAndDelayTime(&feedback, delayTime);
    mux2.setInput(&delay);
    amp2.setInput(&mux2);
    amp2.setGain(1.0 - g*g);
    sum.addInput(&amp2);
    amp3.setInput(&mux2);
    amp3.setGain(g);
    feedback.setFeedbackInput(&amp3);
    
    return SPKitProcessor::setInput(&sum);
}

void SPKitAllPassNetwork::setG(SPKitFloat value)
{
    g = value;

    if (g >= 1.0)
	g = 0.9999;
    else if (g <= 0.0)
	g = 0.0001;
	
//    feedback.setFeedbackTime(delayTime * 1.0/g);
    reverbTime = 3 * delayTime / log10(1.0 / g);
    feedback.setFeedbackTime(reverbTime);
    amp1.setGain(-g);
    amp2.setGain(1.0 - g*g);
    amp3.setGain(g);
}

void SPKitAllPassNetwork::setReverbTime(SPKitFloat value)
{
    reverbTime = value;
    g = pow(0.001, delayTime / reverbTime);

    feedback.setFeedbackTime(reverbTime);
    amp1.setGain(-g);
    amp2.setGain(1.0 - g*g);
    amp3.setGain(g);
}
