// comb.h
/*
 * comb: the comb filter class
 * Copyright (c) 1995 Janne Halmkrona
 */

#ifndef _SPKIT_COMB_H_
#define _SPKIT_COMB_H_

#include "processo.h"
#include "fbdelay.h"
#include "amp.h"
#include "mux.h"
#include "feedback.h"

class SPKitComb : public SPKitProcessor {
public:
	int setInputAndDelayTime(SPKitProcessor* input, SPKitFloat delayTime);
        void setReverbTime(SPKitFloat reverbTime);

	SPKitFloat getReverbTime() const;

protected:
	SPKitFloat reverbTime, delayTime;
	SPKitFloat g;
	SPKitFeedback feedback;
	SPKitFBDelay fbdelay;
	SPKitAmp amp;
	SPKitMux mux;
};

inline SPKitFloat SPKitComb::getReverbTime() const
{
	return reverbTime;
}

#endif
