// compress.cc

#include "compress.h"

// #define DEBUG

#ifdef DEBUG
#include <stdio.h>
#endif


SPKitCompressor::SPKitCompressor()
{
    ratio = 1.0;
}

void SPKitCompressor::setRatio(SPKitFloat r)
{
    ratio = r > 0.0 ? r : 0.0001;
}

void SPKitCompressor::scaleBuffer()
{
    SPKitSample scale;
    SPKitSample scale1;
    SPKitSample scale2;
    SPKitSample scaleIncrement;
    int i = writeIndex;
    
#ifdef DEBUG
    printf("absMax1 = %lg, absMax2 = %lg\n", absMax1, absMax2);
#endif

    if (absMax1 <= threshold && absMax2 <= threshold)
	return;
	
    if (absMax1 > threshold)
	scale1 = ((absMax1 - threshold) / ratio + threshold) / absMax1;
    else
	scale1 = 1.0;
	
    if (absMax2 > threshold)
	scale2 = ((absMax2 - threshold) / ratio + threshold) / absMax2;
    else
	scale2 = 1.0;

#ifdef DEBUG
    printf("scale1 = %lg, scale2 = %lg\n", scale1, scale2);
#endif

    scaleIncrement = (scale2 - scale1) / (inputBufSize
		    / inputChannelCount);
    
    scale = scale1;
    while (i != processIndex) {
	sampleBuffer[i] *= scale;
	i++;
	i %= bufSize;
	if (i % inputChannelCount == 0)
	    scale += scaleIncrement;
    }
}
