// dynamics.cc

#include "dynamics.h"
#include <math.h>

SPKitError SPKitDynamicsProcessor::setInputAndEstimationTime(
					    SPKitProcessor* ip,
					    SPKitFloat et)
{
    SPKitError errCode;
    
    if ((errCode = SPKitProcessor::setInput(ip)) != 0)
	return errCode;

    inputBufSize = SPKitInt(et * inputSamplingRate) * inputChannelCount;
    if (inputBufSize % 2 != 0) // inputBufsize must be divisible by 2
	++inputBufSize;
    halfInputBufSize = inputBufSize / 2;
    bufSize = inputBufSize + halfInputBufSize;

    sampleBuffer = new SPKitSample[bufSize];

    firstTime = 1;
    endOfInput = 0;
    
    writeIndex = 0;
    readIndex = 0;
    processIndex = 0;
    
    threshold = 0.7;
    
    return 0;
}

int SPKitDynamicsProcessor::getSample(SPKitSample& outputSample)
{
    int i;
    SPKitSample inputSample;
    
    if (writeIndex != processIndex) {
	outputSample = sampleBuffer[writeIndex++];
	writeIndex %= bufSize;
	return 1;
    }

    if (endOfInput) {
	processIndex = readIndex;
	scaleBuffer();
	if (writeIndex != processIndex) {
	    outputSample = sampleBuffer[writeIndex++];
	    writeIndex %= bufSize;
	    return 1;
	} else
	    return 0;
    }
	
    if (firstTime) {
	firstTime = 0;
	absMax1 = absMax2 = 0.0;
	for (i = 0; i < halfInputBufSize; i++) {
	    if (input->getSample(inputSample) == 0) {
		endOfInput = 1;
		processIndex = readIndex;
		break;
	    }
	    sampleBuffer[readIndex] = inputSample;
	    if (fabs(inputSample) > absMax1)
		absMax1 = absMax2 = fabs(inputSample);
	    readIndex++;
	    processIndex++;
	}
	for (i = 0; !endOfInput && i < halfInputBufSize; i++) {
	    if (input->getSample(inputSample) == 0) {
		endOfInput = 1;
		break;
	    }
	    sampleBuffer[readIndex] = inputSample;
	    if (fabs(inputSample) > absMax2)
		absMax2 = fabs(inputSample);
	    readIndex++;
	    processIndex++;
	}
	for (i = 0; !endOfInput && i < halfInputBufSize; i++) {
	    if (input->getSample(inputSample) == 0) {
		endOfInput = 1;
		break;
	    }
	    sampleBuffer[readIndex] = inputSample;
	    if (fabs(inputSample) > absMax2)
		absMax2 = fabs(inputSample);
	    readIndex = (readIndex + 1) % bufSize;
	}
    } else {
	absMax1 = absMax2;
        absMax2 = 0.0;
	for (i = 0; !endOfInput && i < inputBufSize; i++) {
	    if (input->getSample(inputSample) == 0) {
		endOfInput = 1;
		break;
	    }
	    sampleBuffer[readIndex] = inputSample;
	    if (fabs(inputSample) > absMax2)
		absMax2 = fabs(inputSample);
	    readIndex++;
	    readIndex %= bufSize;
	    processIndex++;
	    processIndex %= bufSize;
	}
    }
    scaleBuffer();

    if (writeIndex != processIndex) {
	outputSample = sampleBuffer[writeIndex++];
	writeIndex %= bufSize;
	return 1;
    } else
	return 0;
}
	