/* getsndhe.c */
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#include <stdio.h>
#include "header.h"

int getSndHeader(SndHeader **hp, FILE *fp)
{
    if (fread(*hp, sizeof(SndHeader), 1, fp) == 0)
	return 0;

#ifdef __LITTLE_ENDIAN__
    (*hp)->magicNumber = swapUint32((*hp)->magicNumber);
    (*hp)->headerSize = swapUint32((*hp)->headerSize);
    (*hp)->dataSize = swapUint32((*hp)->dataSize);
    (*hp)->dataFormat = swapUint32((*hp)->dataFormat);
    (*hp)->samplingRate = swapUint32((*hp)->samplingRate);
    (*hp)->channelCount = swapUint32((*hp)->channelCount);
#endif

    fseek(fp, (*hp)->headerSize, SEEK_SET);
    return 1;
}
