// mult.cc

#include "mult.h"

SPKitError SPKitMult::setInput(SPKitProcessor* ip)
{
    multInput = 0;
    
    return SPKitProcessor::setInput(ip);
}

void SPKitMult::setMultInput(SPKitProcessor* mip)
{
    multInput = mip;
    multInput->setOutput(this);
}

int SPKitMult::getSample(SPKitSample& outputSample)
{
    SPKitSample multSample;

    outputSample = 0.0;

    if (input->getSample(outputSample) == 0)
	return 0;
    if (!multInput || multInput->getSample(multSample) == 0)
	return 0;

    outputSample *= multSample;
    
    return 1;
}
