/* putsndhe.c */
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#include <stdio.h>
#include "header.h"

int putSndHeader(SndHeader *hp, FILE *fp)
{
#ifdef __LITTLE_ENDIAN__

    SndHeader h;
    int i;

    h.magicNumber = swapUint32(hp->magicNumber);
    h.headerSize = swapUint32(hp->headerSize);
    h.dataSize = swapUint32(hp->dataSize);
    h.dataFormat = swapUint32(hp->dataFormat);
    h.samplingRate = swapUint32(hp->samplingRate);
    h.channelCount = swapUint32(hp->channelCount);
    for (i = 0; i < 4; i++)
    	h.info[i] = hp->info[i];

    return (int) fwrite(&h, sizeof(SndHeader), 1, fp);

#else

    return (int) fwrite(hp, sizeof(SndHeader), 1, fp);

#endif
}
