// resonato.cc

#include "resonato.h"
#include <math.h>

int SPKitResonator::setInput(SPKitProcessor* sp)
{
    channelIndex = 0;

    SPKitProcessor::setInput(sp);

    for (int i = 0; i < inputChannelCount; i++) {
    	chBuf[i] = new SPKitSampleBuffer;
	chBuf[i]->y1 = chBuf[i]->y2 = 0.0;
    }

    return 1;
}

void SPKitResonator::setCenterFreqAndBW(SPKitFloat f, SPKitFloat bw)
{
    centerFreq = f;
    bandwidth = bw;
    
    b2 = exp(-(2 * M_PI) * (bandwidth / inputSamplingRate));
    b1 = (-4.0 * b2) / (1.0 + b2)
	 * cos(2 * M_PI * (centerFreq / inputSamplingRate));
    a0 = (1.0 - b2) * sqrt(1.0 - (b1 * b1) / (4.0 * b2));
}

int SPKitResonator::getSample(SPKitSample& outputSample)
{
    SPKitSample inputSample;

    if (!input->getSample(inputSample))
    	return 0;

    SPKitSampleBuffer* buf = chBuf[channelIndex++];
    channelIndex %= inputChannelCount;

    outputSample = a0 * inputSample - b1 * buf->y1 - b2 * buf->y2;

    buf->y2 = buf->y1;
    buf->y1 = outputSample;

    return 1;
}

SPKitResonator::~SPKitResonator()
{
    for (int i = 0; i < inputChannelCount; i++)
    	delete chBuf[i];
}
    
