// sgireade.cc

#include "sgireade.h"

SPKitSample SPKitReader::int16MaxDenom = 1.0;

SPKitReader::SPKitReader()
{
    audioFile = AF_NULL_FILEHANDLE;
    sampleBuffer = 0;
}

SPKitReader::~SPKitReader()
{
    if (audioFile != AF_NULL_FILEHANDLE)
	AFclosefile(audioFile);
    if (sampleBuffer)
	delete [] sampleBuffer;
}

int SPKitReader::setInput(const char* soundFile)
{
    if ((fd = open(soundFile, O_RDONLY)) < 0)
	return -1;
    if (AFidentifyfd(fd) < 0) 
	return -1;
    /*
     * attach an audio file handle to the file descriptor
     */
    if ((audioFile = 
	      AFopenfd(fd, "r", AF_NULL_FILESETUP)) == AF_NULL_FILEHANDLE)
	return -1;


    // *** *** *** ***
    
    inputSamplingRate = AFgetrate(audioFile, AF_DEFAULT_TRACK);
    inputChannelCount = AFgetchannels(audioFile, AF_DEFAULT_TRACK);
//    originalDataFormat = AFgetfilefmt(audioFile, AF_DEFAULT_TRACK);
    originalDataFormat = AFgetcompression(audioFile, AF_DEFAULT_TRACK);
    framesPerTrack = AFgetframecnt(audioFile, AF_DEFAULT_TRACK);
    
    AFgetsampfmt(audioFile, AF_DEFAULT_TRACK, &sampleType, &sampleWidth);
    
    if (sampleWidth != 16 || sampleType != AF_SAMPFMT_TWOSCOMP)
	return -1;
    
    framesPerBuffer = 1024;
    samplesPerBuffer = framesPerBuffer * inputChannelCount;
    sampleBuffer = new int16[samplesPerBuffer];
    
    samplesLeft = sampleCount = framesPerTrack * inputChannelCount;
    
    int16MaxDenom = 1.0 / SPKitSample(SPKIT_INT16_MAX);

//    AFseekframe(audioFile, AF_DEFAULT_TRACK, 0);
    
    samplesRead = sampleIndex = 0;
    
//    printf("%d samples to read\n", sampleCount);

    return 0;
}


int SPKitReader::getSample(SPKitSample& outputSample)
{
    int16 inputSample;
    long framesRead;
    
    if (sampleIndex == samplesRead) {
	if ((framesRead = AFreadframes(audioFile, AF_DEFAULT_TRACK,
			      (void *)sampleBuffer, framesPerBuffer)) <= 0) {
//	    printf("%d samples read\n", sampleCount - samplesLeft);
	    return 0;
	}
	    
	samplesRead = framesRead * inputChannelCount;
	sampleIndex = 0;
    }
    outputSample = sampleBuffer[sampleIndex++] * int16MaxDenom;
    
    samplesLeft--;
	
    return 1;
}
