// sgiwrite.h
/*
	Copyright (c) 1995 Kai Lassfolk
*/

#ifndef _SPKIT_WRITER_H_
#define _SPKIT_WRITER_H_

#include <stdio.h>
#include <fcntl.h>
#include <math.h>
#include <dmedia/audiofile.h>

#include "processo.h"

class SPKitWriter : public SPKitProcessor {
public:
    SPKitWriter();
    ~SPKitWriter();
    
    SPKitError setInputOutput(SPKitProcessor*, const char*);
    
    void run(); // run until end of input
    int runFor(SPKitInt); // run for specified amount of samples
    
    int getSample(SPKitSample&);

    SPKitInt getSamplesWritten() const;

protected:
    int fd;

    AFfilehandle audioFile;
    AFfilesetup audioFileSetup;
    
    int framesPerBuffer;
    int samplesPerFrame;
    int samplesPerBuffer;

    int16* sampleBuffer;
    
    int samplesWritten;
};

inline SPKitInt SPKitWriter::getSamplesWritten() const
{
    return samplesWritten;
}

inline int SPKitWriter::getSample(SPKitSample& outputSample)
{
    return 0;
}

#endif
