// sum.cc

#include "sum.h"

SPKitError SPKitSum::setInput(SPKitProcessor* p)
{
    if (SPKitProcessor::setInput(p) != 0)
	return -1;

    inputList[0] = input;
    inputCount = 1;

    return 0;
}

int SPKitSum::addInput(SPKitProcessor* sp)
{
    sp->setOutput(this);
    
    if (inputCount >= MAXINPUTS)
    	return -1;

    inputList[inputCount++] = sp;
    
    return 0;
}

int SPKitSum::getSample(SPKitSample& outputSample)
{
    int i;
    int ok;
    SPKitSample inputSample;

    outputSample = 0.0;

    for (i = 0, ok = 0; i < inputCount; i++) {
	if (inputList[i]->getSample(inputSample)) {
	    outputSample += inputSample;
	    ok = 1;
	}
    }
    
    return ok;
}
