{
        (c) 1995 by Andreas Dosche
        This programm is a part of CASCADE 2.1
        See CASCADE.FAQ and COPYING for more infomation!
}
{$m 65500, 0, 20000}
{Do not change the size of the heap!}
uses crt,
     dos,
     strings,
     graph;

type xyz=record
     x: real;
     y: real;
     z: real;
     color: integer;
     atom_type: string[3];
     isolated: boolean;
end;

type bond=record
     x: word;
     y: word;
end;

var
   ch: file of char;
   buffer, buffer_1, buffer_2: string;
   key: char;
   atoms_dec, filename: pathstr;
   number_1, number_2, number_3, fehler: integer;
   count_1, count_2: integer;
   coordinate: array[0..500] of xyz;
   bonds: array[1..1000] of bond;
   out, dat: text;
   isolated_atoms: array[1..20] of integer;
   dats: array[1..120] of integer;
   driver, mode: integer;
   radius, ywinkel, xwinkel, winkel: real;
   scale: integer;
   schirm: byte;
   dist_x, dist_y, flucht: real;
   mid_x, mid_y: integer;
   del: integer;
   centered_atom: integer;
   origin: xyz;
   perspective: boolean;

procedure vgadriver; external;
{$l egavga.obj}

{Reads one single word}
procedure read_word (var fehler: integer);

begin
     buffer := '';
     repeat
           read (ch, key);
           if ioresult <> 0 then fehler := 2;
     until (key >= '!') or eof (ch);
     repeat
           buffer := buffer + key;
           read (ch, key);
           if ioresult <> 0 then fehler := 2;
     until (key < '!') or eof (ch);
end;

procedure read_colors;

begin
     assign (dat, atoms_dec);
     reset (dat);
     repeat
           readln (dat, buffer_1);
           if ioresult <> 0 then fehler := 1;
           if (buffer_1[1] <> ';') and
              (buffer_1[1] <> '*') and
              (buffer_1[1] <> '#') then begin
              count_2 := 0;
              buffer_2 := '';
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    buffer_2 := buffer_2 + buffer_1[count_2];
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              val (buffer_2, count_1, fehler);
              buffer_2 := '';
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    buffer_2 := buffer_2 + buffer_1[count_2];
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              if buffer_2 = 'black' then dats[count_1] := 0;
              if buffer_2 = 'blue' then dats[count_1] := 1;
              if buffer_2 = 'green' then dats[count_1] := 2;
              if buffer_2 = 'cyan' then dats[count_1] := 3;
              if buffer_2 = 'red' then dats[count_1] := 4;
              if buffer_2 = 'magenta' then dats[count_1] := 5;
              if buffer_2 = 'brown' then dats[count_1] := 6;
              if buffer_2 = 'lightgray' then dats[count_1] := 7;
              if buffer_2 = 'darkgray' then dats[count_1] := 8;
              if buffer_2 = 'lightblue' then dats[count_1] := 9;
              if buffer_2 = 'lightgreen' then dats[count_1] := 10;
              if buffer_2 = 'lightcyan' then dats[count_1] := 11;
              if buffer_2 = 'lightred' then dats[count_1] := 12;
              if buffer_2 = 'lightmagenta' then dats[count_1] := 13;
              if buffer_2 = 'yellow' then dats[count_1] := 14;
              if buffer_2 = 'white' then dats[count_1] := 15;
           end;
     until eof (dat);
     close (dat);
     if ioresult <> 0 then fehler := 1;
     if fehler <> 0 then exit;
end;

{Read the coordinates of the atoms}
procedure read_coordinates;

begin
     read_word (fehler);
     buffer_1 := buffer;
     val (buffer_1, number_1, fehler);
     if fehler <> 0 then fehler := 2;
     if fehler <> 0 then exit;

     count_2 := 1;
     repeat
           read_word (fehler);
           buffer_1 := buffer;
           coordinate[count_2].atom_type := buffer_1;
           val (buffer_1, count_1, fehler);
           coordinate[count_2].color := 0;
           coordinate[count_2].color := dats[count_1];
           read_word (fehler);
           val (buffer, coordinate[count_2].x, fehler);
           read_word (fehler);
           val (buffer, coordinate[count_2].y, fehler);
           read_word (fehler);
           val (buffer, coordinate[count_2].z, fehler);
           read_word (fehler);
           if buffer_1 = '0' then begin
              coordinate[count_2].x := 0;
              coordinate[count_2].y := 0;
              coordinate[count_2].z := 0;
           end;
           coordinate[count_2].isolated := true;
           count_2 := count_2 + 1;
     until (count_2 > number_1) or (eof (ch));
end;

{Reads the information about bonds}
procedure read_bonds;

begin
     read_word (fehler);
     if fehler <> 0 then exit;

     read_word (fehler);
     number_2 := 0;
     repeat
           number_2 := number_2 + 1;
           val (buffer, count_1, fehler);
           read_word (fehler);
           bonds[number_2].x := count_1;
           val (buffer, count_2, fehler);
           bonds[number_2].y := count_2;
           read_word (fehler);
           read_word (fehler);
           coordinate[bonds[number_2].x].isolated := false;
           coordinate[bonds[number_2].y].isolated := false;
     until (fehler <> 0) or (eof (ch)) or (buffer = '0');
end;

procedure save_mol;
var
   mode: integer;

begin
     mode := getgraphmode;
     restorecrtmode;
     clrscr;
     write ('Enter new filename (with .mol as extension): ');
     readln (filename);
     setgraphmode (mode);
     assign (out, filename);
     rewrite (out);
     str (number_1:0, buffer_1);
     writeln (out, buffer_1);
     count_1 := 0;
     repeat
           count_1 := count_1 + 1;
           buffer := coordinate[count_1].atom_type + ' ';
           str (coordinate[count_1].x:0:5, buffer_1);
           buffer := buffer + buffer_1 + ' ';
           str (coordinate[count_1].y:0:5, buffer_1);
           buffer := buffer + buffer_1 + ' ';
           str (coordinate[count_1].z:0:5, buffer_1);
           buffer := buffer + buffer_1 + ' 1';
           writeln (out, buffer);
     until count_1 = number_1;
     str (number_2:0, buffer_1);
     writeln (out, '-' + buffer_1);
     count_1 := 0;
     repeat
           count_1 := count_1 + 1;
           str (bonds[count_1].x:0, buffer_1);
           str (bonds[count_1].y:0, buffer_2);
           writeln (out, buffer_1 + ' ' + buffer_2 + ' 1');
     until count_1 = number_2;
     writeln (out, '0');
     close (out);
end;

procedure center (forward: boolean);

var
   center: xyz;

begin
     origin := coordinate[0];
     count_1 := centered_atom;
     if forward then begin
        repeat
              count_1 := count_1 + 1;
        until (coordinate[count_1].atom_type <> '0') or (count_1 > number_1);
     end
     else begin
          repeat
                if count_1 = 0 then count_1 := number_1 + 1;
                count_1 := count_1 - 1;
          until (coordinate[count_1].atom_type <> '0') or (count_1 = 0);
     end;

     if (count_1 <= number_1) and (count_1 > 0) then begin
        centered_atom := count_1;
        center := coordinate[count_1];
        count_2 := 0;
        repeat
              count_2 := count_2 + 1;
              if coordinate[count_2].atom_type <> '0' then begin
                 coordinate[count_2].x := coordinate[count_2].x - center.x;
                 coordinate[count_2].y := coordinate[count_2].y - center.y;
                 coordinate[count_2].z := coordinate[count_2].z - center.z;
              end;
        until count_2 = number_1;
        origin.x := origin.x - center.x;
        origin.y := origin.y - center.y;
        origin.z := origin.z - center.z;
     end;
     if (count_1 > number_1) or (count_1 = 0) then begin
        centered_atom := 0;
        center := origin;
        count_2 := 0;
        repeat
              count_2 := count_2 + 1;
              if coordinate[count_2].atom_type <> '0' then begin
                 coordinate[count_2].x := coordinate[count_2].x - center.x;
                 coordinate[count_2].y := coordinate[count_2].y - center.y;
                 coordinate[count_2].z := coordinate[count_2].z - center.z;
              end;
        until count_2 = number_1;
        origin.x := origin.x - center.x;
        origin.y := origin.y - center.y;
        origin.z := origin.z - center.z;
     end;
     coordinate[0] := origin;
end;

procedure rotate;

begin
     centered_atom := 0;
     coordinate[0].x := 0;
     coordinate[0].y := 0;
     coordinate[0].z := 0;
     driver := registerbgidriver (@vgadriver);
     del := 10;
     schirm := 0;
     flucht := 1;
     xwinkel := 0;
     ywinkel := 0;
     scale := -40;
     driver := 9;
     mode := 1;
     initgraph (driver, mode, '');
     repeat
           count_1 := -1;
           repeat
                 count_1 := count_1 + 1;
                 if (coordinate[count_1].x <> 0) or (coordinate[count_1].y <> 0) or (coordinate[count_1].z <> 0) then begin
                    radius := sqrt (sqr (coordinate[count_1].z) + sqr (coordinate[count_1].x));
                    if coordinate[count_1].x <> 0 then begin
                       winkel := arctan (coordinate[count_1].z / coordinate[count_1].x);
                       if coordinate[count_1].x < 0 then winkel := winkel + Pi;
                    end
                    else begin
                         if coordinate[count_1].z = 0 then winkel := 0;
                         if coordinate[count_1].z > 0 then winkel := Pi / 2;
                         if coordinate[count_1].z < 0 then winkel := 3 * Pi / 2;
                    end;
                    coordinate[count_1].z := sin (winkel + ywinkel * Pi / 180) * radius;
                    coordinate[count_1].x := cos (winkel + ywinkel * Pi / 180) * radius;

                    radius := sqrt (sqr (coordinate[count_1].z) + sqr (coordinate[count_1].y));
                    if coordinate[count_1].y <> 0 then begin
                       winkel := arctan (coordinate[count_1].z / coordinate[count_1].y);
                       if coordinate[count_1].y < 0 then winkel := winkel + Pi;
                    end
                    else begin
                         if coordinate[count_1].z = 0 then winkel := 0;
                         if coordinate[count_1].z > 0 then winkel := Pi / 2;
                         if coordinate[count_1].z < 0 then winkel := 3 * Pi / 2;
                    end;
                    coordinate[count_1].z := sin (winkel + xwinkel * Pi / 180) * radius;
                    coordinate[count_1].y := cos (winkel + xwinkel * Pi / 180) * radius;
                 end;
           until count_1 = number_1;
           count_1 := 0;
           setactivepage (schirm);
           cleardevice;
           repeat
                 count_1 := count_1 + 1;
                 if (coordinate[bonds[count_1].x].z + flucht) < 5 then flucht := flucht + 1;
                 if (coordinate[bonds[count_1].y].z + flucht) < 5 then flucht := flucht + 1;
                 if perspective then begin
                    dist_x := (coordinate[bonds[count_1].x].z + flucht) / flucht;
                    dist_y := (coordinate[bonds[count_1].y].z + flucht) / flucht;
                 end
                 else begin
                    dist_x := 1.2;
                    dist_y := 1.2;
                 end;
                 mid_x := round ((scale * dist_x * coordinate[bonds[count_1].x].x + 320 +
                       scale * dist_y * coordinate[bonds[count_1].y].x + 320) / 2);
                 mid_y := round ((0.73 * scale * dist_x * coordinate[bonds[count_1].x].y + 175 +
                       0.73 * scale * dist_y * coordinate[bonds[count_1].y].y + 175) / 2);
                 setcolor (coordinate[bonds[count_1].x].color);
                 line (round (scale * dist_x * coordinate[bonds[count_1].x].x + 320),
                      round (0.73 * scale * dist_x * coordinate[bonds[count_1].x].y + 175),
                      mid_x, mid_y);
                 setcolor (coordinate[bonds[count_1].y].color);
                 line (round (scale * dist_y * coordinate[bonds[count_1].y].x + 320),
                      round (0.73 * scale * dist_y * coordinate[bonds[count_1].y].y + 175),
                      mid_x, mid_y);
           until count_1 = number_2;
           count_1 := 0;
           while count_1 < number_3 do begin
                 count_1 := count_1 + 1;
                 setfillstyle (1, coordinate[isolated_atoms[count_1]].color);
                 setcolor (coordinate[isolated_atoms[count_1]].color);
                 if perspective then begin
                    dist_x := (coordinate[bonds[count_1].x].z + flucht) / flucht;
                    dist_y := (coordinate[bonds[count_1].y].z + flucht) / flucht;
                 end
                 else begin
                    dist_x := 1.2;
                    dist_y := 1.2;
                 end;
                 pieslice (round (scale * dist_x * coordinate[isolated_atoms[count_1]].x + 320),
                          round (0.73 * scale * dist_x * coordinate[isolated_atoms[count_1]].y + 175),
                          0, 360, 4);
           end;
           if centered_atom <> 0 then begin
              setcolor (coordinate[centered_atom].color);
              circle (320,175, 5);
           end;
           setvisualpage (schirm);
           if schirm = 0 then schirm := 1 else schirm := 0;
           delay (del);
           if keypressed then begin
              key := readkey;
              if key = 'o' then begin
                 if perspective = false then perspective := true
                 else perspective := false;
              end;
              if key = 'z' then center (true);
              if key = 'Z' then center (false);
              if key = 's' then save_mol;
              if key = '+' then scale := scale - 5;
              if key = '-' then scale := scale + 5;
              if key = 'c' then del := del + 5;
              if (key = 'd') and (del > 0) then del := del - 5;
              if key = 'h' then begin
                 mode := getgraphmode;
                 restorecrtmode;
                 clrscr;
                 writeln ('Up:    rotate up');
                 writeln ('Left:  rotate down');
                 writeln ('Right: rotate right');
                 writeln ('Left:  rotate left');
                 writeln ('SPACE: stop rotation');
                 writeln ('+/-:   zoom in / zoom out');
                 writeln ('d/c:   increase / decrease rotation-speed');
                 writeln ('z:     select atoms to center');
                 writeln ('o:     switch between perspective/orthogonal drawing');
                 writeln ('s:     save coordinates in new.mol');
                 writeln ('ESC:   quit');
                 writeln ('g:     back to graphic');
                 writeln ('');
                 writeln ('(c) 1995 by Andreas Dosche');
                 writeln ('PREVIEW is a part of CASCADE 2');
                 writeln ('See FAQ and COPYING for more information');
                 repeat until keypressed;
                 key := readkey;
                 setgraphmode (mode);
              end;
              if key = ' ' then begin
                 xwinkel := 0;
                 ywinkel := 0;
              end;
              if ord (key) = 0 then begin
                 key := readkey;
                 if ord (key) = 72 then xwinkel := xwinkel - 1;
                 if ord (key) = 80 then xwinkel := xwinkel + 1;
                 if ord (key) = 75 then ywinkel := ywinkel - 1;
                 if ord (key) = 77 then ywinkel := ywinkel + 1;
              end;
           end;
     until ord (key) = 27;
     setvisualpage (0);
     setactivepage (0);
     closegraph;
end;

procedure search_isolated_atoms;

begin
     count_1 := 0;
     number_3 := 0;
     repeat
           count_1 := count_1 + 1;
           if (coordinate[count_1].isolated = true) and (coordinate[count_1].atom_type <> '0') then begin
              number_3 := number_3 + 1;
              isolated_atoms[number_3] := count_1;
           end;
     until count_1 = number_1;
     if number_3 > 0 then begin
        clrscr;
        writeln ('Found ', number_3:0, ' isolated atom(s)!');
        writeln ('Press g to start...');
        repeat until keypressed;
        key := readkey;
     end;
end;

begin
     perspective := false;
     clrscr;
     writeln ('Please wait ...');
     filename := paramstr (1);
     atoms_dec := paramstr (2);
     if notexist (filename) then exit;
     if notexist (atoms_dec) then exit;
     read_colors;
     assign (ch, filename);
     reset (ch);
     read_coordinates;
     read_bonds;
     search_isolated_atoms;
     rotate;
     close (ch);
end.
