/************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York

   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: os_connectivity.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/



#ifndef _H_OS_CONNECTIVITY
#define _H_OS_CONNECTIVITY
#include <ostore/ostore.hh>
#include "oopdb_setup.h"
#include "connectivity.h"

class OSConnectionInfo : public ConnectionInfo {
 public:
  OSConnectionInfo(){};
  OSConnectionInfo(const ConnectionInfo&);
  Bound_atom * new_bound_atom(Bound_atom*);
};


class OSSubEntityConnectivity : public SubEntityConnectivity {
 public:
  OSSubEntityConnectivity(){}
  OSSubEntityConnectivity(const SubEntityConnectivity &s);
  ConnectionInfo * new_connection_info(int);
};


class OSConnectivitySet : public ConnectivitySet {
 public:
  OSConnectivitySet() {}
  OSConnectivitySet(ConnectivitySet &c);
  SubEntityConnectivity * new_subentity_connectivity();
};


#endif









