 /*
  * Khoros: $Id: lvshape.h,v 1.1 1991/05/10 04:15:50 khoros Exp $
  */

 /*
  * $Log: lvshape.h,v $
 * Revision 1.1  1991/05/10  04:15:50  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: lvshape.h                              <<<<
   >>>>                                                       <<<<
   >>>>      contains: Definition of the statistical inform-  <<<<
   >>>>                ation structure used by lvshape.       <<<<
   >>>>                                                       <<<<
   >>>>      written by: Pascal Adam			      <<<<
   >>>>                                                       <<<<
   >>>>      date: 2/14/90                                    <<<<
   >>>>                                                       <<<<
   >>>>      modifications:				      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _lvshape_h_
#define _lvshape_h_


typedef struct xvshape  {

   double surf_image;   /* Number of pixels in the entire image ...... */
   double area;         /* Number of pixels in the object   = m00 .... */
   double percent_area; /* Ratio area / surf_image ................... */
   double real_area;    /* Area in square meters ..................... */
   double xcent;        /* x_cent of object .......................... */
   double ycent;        /* y_cent of object .......................... */
   double sigma_x;      /* variance = sqrt [ mu20 / m00 ] ............ */
   double sigma_y;      /*          = sqrt [ mu02 / m00 ] ............ */
                        /* Idem but on principal axis ................ */
   double sigma_MX;     /*          = sqrt [ MX / m00 ] .............. */
   double sigma_MY;     /*          = sqrt [ MY / m00 ] .............. */
   double theta;        /* angle between the major axis of the shape   */
                        /* and the horizontal ........................ */
                        /*                                             */
                        /*                                             */
                        /*                    |   2 mu11    |          */
                        /* theta = 0.5 arctan | ___________ |          */
                        /*                    |             |          */
                        /*                    | mu20 - mu02 |          */
                        /*                                             */
                        /*                                             */

   double eccentricity; /*  Measures the eccentricity of the figure    */
/*          mu02 cos(theta)^2 + mu20 sin(theta)^2 - mu11 sin(2 theta)  */
/*  = SQRT  _________________________________________________________  */
/*          mu02 sin(theta)^2 + mu20 cos(theta)^2 + mu11 cos(2 theta)  */

                        /*                                             */
                        /*                                             */
                        /*                                             */
                        /* two dimensional (p+q)th order moments       */
                        /*                                             */
                        /*                  p  q                       */
                        /* m   = sum  sum  i  j   I(i,j) p,q = 0,1,2,..*/
                        /*  pq    i    i                               */ 
                        /*                                             */
                        /* I(i,j) is the grey level of the pixel, for  */
                        /* application where the grey level is a clus- */
                        /* ter number or a label number, the moments   */
                        /* will be computed for each "object" or class */
                        /* assuming that I(i,j) = 1 inside the class   */
                        /*                      = 0 outside the class  */
   double  m00;         /* represent the area if I(i,j) = 0 or 1       */
   double  m01;         /*    "      sum of y if ......                */
   double  m10;         /*    "      sum of x if ......                */
   double  m11;         /*    "      sum of xy if .....                */
   double  m20;         /*    "      sum of ...........                */
   double  m02;         /*    "      sum of ...........                */
   double  m21;         /*    "      sum of ...........                */
   double  m12;         /*    "      sum of ...........                */
   double  m03;         /*    "      sum of ...........                */
   double  m30;         /*    "      sum of ...........                */

                        /* central moments ........................... */
                        /* If the coordinate system is shifted so that */
                        /* its origin coincides with the centroid x,y  */
                        /* the new set of moment are invariant under   */
                        /* the translation.............................*/
                        /*                                             */
                        /*                      _  p     _  q          */
                        /*  mu   = sum sum (i - x ) (j - y )   I(i,j)  */
                        /*    pq    i   j                              */
                        /*                                             */
                        /*                                             */
                        /*  Another way to compute mu   is:            */
                        /*                           pq                */
                        /*                                             */
                        /*           p   q  p  q    _ r   _ s          */
                        /*  mu  = sum sum  C  C  ( -x) ( -y) m         */
                        /*    pq   r=0 s=0  r  s              p-r,q-s  */
                        /*                                             */
                        /*   p        p!                               */
                        /*  C   = -----------                          */
                        /*   q    r! (p - r)!                          */
                        /*                                             */
                        
   double mu00;         
   double mu10;         
   double mu01;         
   double mu20;         
   double mu02;         
   double mu11;         
   double mu30;         
   double mu03;         
   double mu21;         
   double mu12;        


                        /* Normalized central moments ................ */
                        /*          mu                                 */
                        /*            pq                               */
                        /*  nu   =  _____     with k = (p+q)/2 + 1     */
                        /*    pq                                       */
                        /*              k                              */
                        /*          mu                                 */
                        /*            00                               */
   double nu00;         
   double nu10;         
   double nu01;         
   double nu20;         
   double nu02;         
   double nu11;         
   double nu30;         
   double nu03;         
   double nu21;         
   double nu12;        
                        /* moments invariants .......................  */ 
                        /* This set of momnents is invariant under     */
                        /* rotation, reflection, translation and size  */
    
   double M1;           /* M1 = mu20 + mu02     .....................  */
   double M2;           /* M2 = (mu20-mu02)^2 + 4*(mu11)^2  .........  */
   double M3;           /* M3 = (mu30 -3*mu12)^2 + (3*mu21 -mu03)^2 .  */
   double M4;           /* M4 = (mu30 + mu12)^2 + (mu03 + mu21)^2 ...  */
   double M5;           /* M5 =  ..... too long cf code .............  */
   double M6;           /* M6 =  ....................................  */ 
   double M7;           /* M7 =  ........ (attention: sensitive to     */
                        /*       reflection).........................  */

    int    right;	/* gives the rightmost point of the object     */
    int    left;	/* gives the leftmost point of the object      */
    int    top;		/* gives the uppermost point of the object     */
    int    bottom;	/* gives the lowest point of the object        */
  
    int    axis_x1deb;  /* gives moment on principal axis 1.           */
    int    axis_x1end;  /* gives moment on principal axis 1.           */
    int    axis_y1deb;  /* gives moment on principal axis 1.           */
    int    axis_y1end;  /* gives moment on principal axis 1.           */

    int    axis_x2deb;  /* gives moment on principal axis 2.           */
    int    axis_x2end;  /* gives moment on principal axis 2.           */
    int    axis_y2deb;  /* gives moment on principal axis 2.           */
    int    axis_y2end;  /* gives moment on principal axis 2.           */

} XVSHAPE;

#endif
