 /*
  * Khoros: $Id: matrix_lex.l,v 1.2 1992/03/20 23:36:20 dkhoros Exp $
  */

 /*
  * $Log: matrix_lex.l,v $
 * Revision 1.2  1992/03/20  23:36:20  dkhoros
 * VirtualPatch5
 *
  */ 

%{

#ifndef FILE 
#include <stdio.h>
#endif
#include "kfile.h"
#include "matrix.h"
#include "y.tab.h"

extern YYSTYPE yylval;
extern kfile *kflptr;
int c;
double temp,atof();
int _mwaiting = 0;
int _mwaitchar, _mfgetc();
void _mungetc();

/*
** the following definitions stolen from xvparser:
*/

#undef output
#define output(c)

#undef input
#define input() ((c = _mfgetc(kflptr))==EOF ? 0 : c)

#undef unput
#define unput(c) _mungetc(c)

%}

S	[ ,\t\n]*
B	[a-zA-Z][a-zA-Z0-9_]*
D	[0-9]
E	[eE][-+]?{D}+

%%


"#".*		{ ; }		/* skip all comments */

{S}		{ ; }		/* skip all blanks, etc. */

{D}+			|
{D}+"."{D}*({E})?	|
{D}*"."{D}+({E})?	|
{D}+{E}			{
			  /* sscanf(strcat(yytext,"\0")," %f ",&temp);
			  yylval.real = (double)temp; */
			  yylval.real = (double)atof(strcat(yytext,"\0"));
			  return(NUMBER);
			}


";"	{ return(DELIMITER); }	

"("	{ return(CBEGIN); }
")"	{ return(CEND); }
"<"	{ return(MBEGIN); }
">"	{ return(MEND); }
"["	{ return(MBEGIN); }
"]"	{ return(MEND); }
"+"	{ return(PLUS); }
"-"	{ return(MINUS); }

%%


/***********************************************************************
*
*  Routine Name: _mfgetc()
*
*          Date: Thu Mar 19 17:09:07 MST 1992
*        
*       Purpose: implements an fgetc with the ability to get chars
*                that have been ungotten.  
*
*         Input: kfile *kf - transport object ala Mark Young 
*
*        Output: returns either EOF or a character 
*
*    Written By: Jeremy Worley 
*
* Modifications:
*
***********************************************************************/

int _mfgetc(kf)
  kfile *kf;
{
  if(!_mwaiting)return(kfgetc(kf));

  _mwaiting = !_mwaiting;

  return(_mwaitchar);
}

/***********************************************************************
*
*  Routine Name: _mungetc(c)
*
*          Date: Thu Mar 19 17:10:52 MST 1992
*        
*       Purpose: implements an unget capability with the transport
*                software.  
*
*         Input: int c - the character to be ungotten 
*
*        Output: nothin' man!!!
*
*    Written By: Jeremy Worley 
*
* Modifications:
*
***********************************************************************/

void _mungetc(c)
  int c;
{
  _mwaiting = 1;
  _mwaitchar = c;
}
