#! /bin/csh -f

# 
#  Khoros: $Id: check_csh.csh,v 1.2 1991/12/18 08:53:51 dkhoros Exp $
#

#
# $Log: check_csh.csh,v $
# Revision 1.2  1991/12/18  08:53:51  dkhoros
# HellPatch3
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                         <<<<
#  >>>>	    file name: check_csh.csh                            <<<<
#  >>>>                                                         <<<<
#  >>>>   description: utility for checking dates of program    <<<<
#  >>>>                files generated with the ghost routines. <<<<
#  >>>>                                                         <<<<
#  >>>> modifications:					        <<<<
#  >>>>                                                         <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

#
# ROUTINE NAME:    check_csh.csh
#
# AUTHORS:      Tom Sauer & Danielle Argiro, Per Lysne
#
# DATE:         5/1/90
#
# DESCRIPTION: This is a shell script to check dates of program files 
#	       generated with ghostreader & ghostwriter, ie,
#	       *.c, *.h, l*.c *.1, *.3, *.pane, and *.prog where '*' is
#	       the name of the program.
#
# ROUTINES:    check_csh.csh
#

set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
    /usr/bin /bin /usr/local/etc/ /usr/etc /etc )


set NAME_PROG   = $1
set CONFIG_FLAG = $2
set CONFIG_FILE = $NAME_PROG".conf"

#  Input Argument Checking
#------------------------------------------------------------
if ($#argv != 2) then
  echo ""
  echo "ghostcheck: Invalid number of arguments detected."
  echo "Please invoke this script from the C driver program."
  echo ""
  exit 0
endif

if ($NAME_PROG == "") then
   echo ""
   echo "ghostcheck: name argument is required"
   echo ""
   exit (1)
endif

### if (-config) was set, check to make sure that config file exists
### if config file doesn't exist, error mesg & exit 
### if config file not specified, use . directory
### else get paths out of the config file specified, using sed
   
if ($CONFIG_FLAG) then
      if (! -e $CONFIG_FILE) then
	 echo ""
	 echo "ghostcheck: config file $CONFIG_FILE does not exist."
	 echo ""
         exit 1
      else
         set CFILE_PATH  = `fgrep cfile: $CONFIG_FILE | awk '{ print $2 }'`
	 if ( $CFILE_PATH == "") then
	     set CFILE_PATH = "."
	 endif
         set HFILE_PATH  = `fgrep hfile: $CONFIG_FILE | awk '{ print $2 }'`
	 if ( $HFILE_PATH == "") then
	     set HFILE_PATH = "."
	 endif
         set LFILE_PATH  = `fgrep lfile: $CONFIG_FILE | awk '{ print $2 }'`
	 if ( $LFILE_PATH == "") then
	     set LFILE_PATH = "."
	 endif
         set MAN1FILE_PATH = `fgrep man1file: $CONFIG_FILE | awk '{ print $2 }'`
	 if ( $MAN1FILE_PATH == "") then
	     set MAN1FILE_PATH = "."
	 endif
         set MAN3FILE_PATH = `fgrep man3file: $CONFIG_FILE | awk '{ print $2 }'`
	 if ( $MAN3FILE_PATH == "") then
	     set MAN3FILE_PATH = "."
	 endif
         set PROGFILE_PATH = `fgrep progfile: $CONFIG_FILE | awk '{ print $2 }'`
	 if ( $PROGFILE_PATH == "") then
	     set PROGFILE_PATH = "."
	 endif
         set PANEFILE_PATH = `fgrep panefile: $CONFIG_FILE | awk '{ print $2 }'`
	 if ( $PANEFILE_PATH == "") then
	     set PANEFILE_PATH = "."
	 endif
      endif
else
      set    CFILE_PATH = "."
      set    HFILE_PATH = "."
      set    LFILE_PATH = "."
      set MAN1FILE_PATH = "."
      set MAN3FILE_PATH = "."
      set PROGFILE_PATH = "."
      set PANEFILE_PATH = "."
endif

### get info about *.c, *.h, l*.c, *.1, *.3, *.pane, and *.prog 
### make sure they exist, and get their paths.
#
# Use one of the following commands to substitute $KHOROS_HOME with it's expanded environment value
#
#       set tt=`echo $t | sed -e s%'$KHOROS_HOME'%$KHOROS_HOME%g`
#				or
#       set MAN1FILE = `echo "echo $MAN1FILE_PATH/$NAME_PROG.1" | csh -sf`
#

set CFILE = `echo $CFILE_PATH/$NAME_PROG.c | tr -d $ | sed -e s%\KHOROS_HOME%$KHOROS_HOME%g`
if (! -e $CFILE) then
   echo "$CFILE          does not exist"
   set CFILE = ""
endif

set LFILE = `echo $LFILE_PATH/l$NAME_PROG.c | tr -d $ | sed -e s%\KHOROS_HOME%$KHOROS_HOME%g`
if (! -e $LFILE ) then
   echo "$LFILE         does not exist"
   set LFILE = ""
endif

set HFILE = `echo $HFILE_PATH/$NAME_PROG.h | tr -d $ | sed -e s%\KHOROS_HOME%$KHOROS_HOME%g`
if (! -e $HFILE) then
   echo "$HFILE          does not exist"
   set HFILE = ""
endif

set MAN1FILE = `echo $MAN1FILE_PATH/$NAME_PROG.1 | tr -d $ | sed -e s%\KHOROS_HOME%$KHOROS_HOME%g`
if (! -e $MAN1FILE) then
   echo "$MAN1FILE          does not exist"
   set MAN1FILE = ""
endif

set MAN3FILE = `echo $MAN3FILE_PATH/l$NAME_PROG.3 | tr -d $ | sed -e s%\KHOROS_HOME%$KHOROS_HOME%g`
if (! -e $MAN3FILE) then
   echo "$MAN3FILE         does not exist"
   set MAN3FILE = ""
endif

set PANEFILE = `echo $PANEFILE_PATH/$NAME_PROG.pane | tr -d $ | sed -e s%\KHOROS_HOME%$KHOROS_HOME%g`
if (! -e $PANEFILE) then
   echo "$PANEFILE       does not exist"
   set PANEFILE = ""
endif

set PROGFILE = `echo $PROGFILE_PATH/$NAME_PROG.prog | tr -d $ | sed -e s%\KHOROS_HOME%$KHOROS_HOME%g`
if (! -e $PROGFILE) then
   echo "$PROGFILE       does not exist"
   set PROGFILE = ""
endif

###  
###   basic error checking
###
 
if (($CFILE == "") && ($HFILE == "") && \
    ($PROGFILE == "") && ($PANEFILE == "")) then
   echo ""
   echo "ghostcheck:"
   echo "WARNING: Either you have used the wrong name as input to check,"
   echo "or your pathname to these files is wrong, or there is "
   echo "no such program"
   echo ""
   exit 0
endif

if (($CFILE == "") && ($HFILE == "")) then
   echo ""
   echo "ghostcheck:"
   echo "WARNING: since $NAME_PROG.c and $NAME_PROG.h do not exist,"
   echo "either you have used the wrong name as input to check,"
   echo "or your pathname to these files is wrong."
   echo "please check usage, and try again."
   echo ""
   exit 0
endif

if ($PROGFILE == "") then
     echo ""
     echo "ghostcheck:"
     echo "WARNING: Since $NAME_PROG.prog does not seem to exist, "
     echo "either your pathname to this file is wrong,"
     echo "or you may want to create a .prog file from your code and" 
     echo "man pages using ghostreader."
     echo ""
     exit 0
endif

if ($PANEFILE == "") then
     echo ""
     echo "ghostcheck:"
     echo "WARNING: Could not find $NAME_PROG.pane"
     echo "either your pathname to this file is wrong,"
     echo "or you may have used the wrong path to .pane location."
     echo ""
     exit 0
endif

if ($LFILE == "") then
   echo ""
   echo "ghostcheck:"
   echo "WARNING: Could not find l$NAME_PROG.c"
   echo "you may have used the wrong path to library file location."
   echo ""
endif

if ($HFILE == "") then
   echo ""
   echo "ghostcheck:"
   echo "WARNING: Could not find $NAME_PROG.h"
   echo "you may have used the wrong path to include file location."
   echo ""
endif

if ($CFILE == "") then
   echo ""
   echo "ghostcheck:"
   echo "WARNING: Could not find $NAME_PROG.c"
   echo "you may have used the wrong path to source file location."
   echo ""
endif

if ($MAN1FILE == "") then
   echo ""
   echo "ghostcheck:"
   echo "WARNING: Could not find $NAME_PROG.1"
   echo "you may have used the wrong path to man1 location,"
   echo "or, if no man1 file exists, don't be lazy - now is"
   echo "a great time to create one using ghostwriter"
   echo ""
endif

if ($MAN3FILE == "") then
   echo ""
   echo "ghostcheck:"
   echo "WARNING: Could not find l$NAME_PROG.3"
   echo "you may have used the wrong path to man3 location,"
   echo "or, if no man3 file exists, don't be lazy - now is "
   echo "a great time to create one using ghostwriter"
   echo ""
endif

###  do an ordered listing into tmp file, 
###  arrange info, and print it out 

\ls -lt $PROGFILE $PANEFILE $MAN3FILE $MAN1FILE $LFILE $HFILE $CFILE > /tmp/checkfile.$$

set FIRST_FILE    = `sed -n '1,1p' /tmp/checkfile.$$ | awk '{print $8}'`
set FIRST_DATE    = `sed -n '1,1p' /tmp/checkfile.$$ | awk '{print $5 $6 $7}'`

set SECOND_FILE   = `sed -n '2,2p' /tmp/checkfile.$$ | awk '{print $8}'`
set SECOND_DATE   = `sed -n '2,2p' /tmp/checkfile.$$ | awk '{print $5 $6 $7}'`

set THIRD_FILE    = `sed -n '3,3p' /tmp/checkfile.$$ | awk '{print $8}'`
set THIRD_DATE    = `sed -n '3,3p' /tmp/checkfile.$$ | awk '{print $5 $6 $7}'`

set FOURTH_FILE   = `sed -n '4,4p' /tmp/checkfile.$$ | awk '{print $8}'`
set FOURTH_DATE   = `sed -n '4,4p' /tmp/checkfile.$$ | awk '{print $5 $6 $7}'`

set FIFTH_FILE    = `sed -n '5,5p' /tmp/checkfile.$$ | awk '{print $8}'`
set FIFTH_DATE    = `sed -n '5,5p' /tmp/checkfile.$$ | awk '{print $5 $6 $7}'`

set SIXTH_FILE    = `sed -n '6,6p' /tmp/checkfile.$$ | awk '{print $8}'`
set SIXTH_DATE    = `sed -n '6,6p' /tmp/checkfile.$$ | awk '{print $5 $6 $7}'`
 
set SEVENTH_FILE  = `sed -n '7,7p' /tmp/checkfile.$$ | awk '{print $8}'`
set SEVENTH_DATE  = `sed -n '7,7p' /tmp/checkfile.$$ | awk '{print $5 $6 $7}'`
\rm /tmp/checkfile.$$

echo ""
if ($FIRST_FILE != "") then
    ls -l $FIRST_FILE   | awk '{printf("%s\t%s %s %s\n", $8, $5, $6, $7)}' 
endif

if ($SECOND_FILE != "") then
    ls -l $SECOND_FILE  | awk '{printf("%s\t%s %s %s\n", $8, $5, $6, $7)}'
endif

if ($THIRD_FILE != "") then
    ls -l $THIRD_FILE   | awk '{printf("%s\t%s %s %s\n", $8, $5, $6, $7)}'
endif

if ($FOURTH_FILE != "") then
   ls -l $FOURTH_FILE  | awk '{printf("%s\t%s %s %s\n", $8, $5, $6, $7)}'
endif

if ($FIFTH_FILE != "") then
    ls -l $FIFTH_FILE   | awk '{printf("%s\t%s %s %s\n", $8, $5, $6, $7)}'
endif

if ($SIXTH_FILE != "") then
    ls -l $SIXTH_FILE   | awk '{printf("%s\t%s %s %s\n", $8, $5, $6, $7)}'
endif

if ($SEVENTH_FILE != "") then
    ls -l $SEVENTH_FILE | awk '{printf("%s\t%s %s %s\n", $8, $5, $6, $7)}'
endif

set DONE_FLAG = 0

### if the .prog &/or .pane files are the most recent files, will want to
### tell the user to use ghostwriter to update *.c, *.h, etc

if (($FIRST_FILE == $PROGFILE) || \
    ($FIRST_FILE == $PANEFILE && $SECOND_FILE == $PROGFILE)) then
   echo ""
   echo "Your .prog file is newer than all of your code. I suggest that you"
   echo "run ghostwriter to update the code."
   echo ""

else if (($SEVENTH_FILE == $PROGFILE) || \
         ($SEVENTH_FILE == $PANEFILE && $SIXTH_FILE == $PROGFILE)) then
   echo ""
   echo "Your .prog file is older than all of your code.  I suggest that you"
   echo "run ghostreader to update the .prog."
   echo ""

else
   echo ""
   echo "Some of your code is newer that your .prog, and some of your code"
   echo "is older than the .prog.  I suggest that you make a backup copy of"
   echo "your .prog file, run ghostreader to create a new .prog, and then"
   echo "'diff' the two .prog files.  Make sure that all of the changes"
   echo "to the old .prog file that did not propagate into the code are"
   echo "transfered to the new .prog, and then run ghostwriter to"
   echo "re-generate your code."
   echo ""
endif


if (($SEVENTH_FILE != $PANEFILE) && \
    ($SEVENTH_FILE != $PROGFILE || $SIXTH_FILE != $PANEFILE)) then
   echo ""
   echo "Some or all of your code is older than your .pane file.  After you"
   echo "finish the instructions above, you should run ghostwriter to make"
   echo "sure that any changes to the .pane are propagated to your code."
   echo "If the instructions above included running ghostwriter then"
   echo "please ignore this warning."
   echo ""
endif


exit 0
