 /*
  * Khoros: $Id: vbandspt3.h,v 1.1 1991/05/10 15:46:55 khoros Exp $
  */

 /*
  * $Log: vbandspt3.h,v $
 * Revision 1.1  1991/05/10  15:46:55  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vbandspt3.h
 >>>>            Author: Tom Sauer
 >>>> Date Last Updated: Tue Mar  5 22:23:04 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vbandspt3_h_
#define _vbandspt3_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vbandspt3 Argument Structure
*
****************************************************************/

typedef struct _vbandspt3  {

/*
 *  input image filename (Required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output image filename (Optional outfile)
 */
char	*o1_file;	/* output image filename FILENAME */
int	 o1_flag;	/* output image filename FLAG */

/*
 *  output image filename (Optional outfile)
 */
char	*o2_file;	/* output image filename FILENAME */
int	 o2_flag;	/* output image filename FLAG */

/*
 *  output image filename (Optional outfile)
 */
char	*o3_file;	/* output image filename FILENAME */
int	 o3_flag;	/* output image filename FLAG */

/*
 *  Data band number to extract (Optional integer)
 */
int	 b_int; 	/* Data band number to extract INT */
int	 b_flag;	/* Data band number to extract FLAG */

}  vbandspt3_struct;

vbandspt3_struct *vbandspt3;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define APPENDFILENAME(image, vbandspt3) \
    switch (image->color_space_model) { \
      case VFF_CM_ntscRGB: \
      case VFF_CM_genericRGB: \
      case VFF_CM_cieRGB: \
            if (!vbandspt3->o1_flag) \
                 img1_file = VStrcat (img1_file, ".R"); \
            if (!vbandspt3->o2_flag) \
                 img2_file = VStrcat (img2_file, ".G"); \
            if (!vbandspt3->o3_flag) \
                 img3_file = VStrcat (img3_file, ".B"); \
            break; \
        case VFF_CM_ntscYIQ: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".Y"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".I"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".Q"); \
            break; \
        case VFF_CM_HLS: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".H"); \
            if (!vbandspt3->o2_flag) \
               img2_file =  VStrcat (img2_file, ".L"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".S"); \
            break; \
        case VFF_CM_HSV: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".H"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".S"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".V"); \
            break; \
        case VFF_CM_ntscCMY: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".C"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".M"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".Y"); \
            break; \
        case VFF_CM_IHS: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".I"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".H"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".S"); \
            break; \
        case VFF_CM_cieXYZ: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".X"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".Y"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".Z"); \
            break; \
        case VFF_CM_cieUVW: \
        case VFF_CM_cieucsUVW: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".U"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".V"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".W"); \
            break; \
        case VFF_CM_cieucsSOW: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".S"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".O"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".W"); \
            break; \
        case VFF_CM_cieucsLab: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".L"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".a"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".b"); \
            break; \
        case VFF_CM_cieucsLuv: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".L"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".u"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".v"); \
            break; \
        case VFF_CM_GENERIC: \
        case VFF_CM_NONE: \
        default: \
            if (!vbandspt3->o1_flag) \
                img1_file = VStrcat (img1_file, ".1"); \
            if (!vbandspt3->o2_flag) \
                img2_file = VStrcat (img2_file, ".2"); \
            if (!vbandspt3->o3_flag) \
                img3_file = VStrcat (img3_file, ".3"); \
            break; \
      }
/* -include_macros_end */

#endif
