 /*
  * Khoros: $Id: vmos2band.c,v 1.2 1992/03/20 23:03:30 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmos2band.c,v 1.2 1992/03/20 23:03:30 dkhoros Exp $";
#endif

 /*
  * $Log: vmos2band.c,v $
 * Revision 1.2  1992/03/20  23:03:30  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmos2band.c
 >>>>
 >>>>      Program Name: vmos2band
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Converts a mosaic input image to an output  image  in  which
 >>>>	each  subimage of the input mosaic constitutes a band of the
 >>>>	output image.
 >>>>	
 >>>>	

 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Tue Mar 17 09:02:13 1992
 >>>>
 >>>>          Routines: main- the main program for vmos2band
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmos2band.h"


/****************************************************************
 *
 * Routine Name:  main program for vmos2band
 *
 *       Input:  
 *           -i  input image 
 *           -o  resulting output image 
 *           -r  number of rows in each subimage (must be same for all subimages)   (value >= 0)
 *           -c  number of columns in each subimage (must be same for all subimages)   (value >= 0)
 *
 *
 *           [-bs] Subimage border size in pixels (inner borders)  (value >= 0)
 *           [-bm] Mosaic image border size in pixels (outer border)  (value >= 0)
 *           [-x] Horzontal index of first subimage (will be first band)  (value >= 0)
 *           [-y] Vertical index of first subimage (will be first band)  (value >= 0)
 *           [-s] Number of subimages to skip (periodic) when putting subimages into band format  (value >= 0)
 *           [-n] Number of subimages to be put into band format  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image, *img1, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
READINPUT(image) ;
CHECKINPUT(program, image) ;

 /*
  * Call the library.
  */
 if (!(lvmos2band(image, &img1, vmos2band->r_int, vmos2band->c_int, vmos2band->bs_int, vmos2band->bm_int, vmos2band->x_int, vmos2band->y_int, vmos2band->s_int, vmos2band->n_flag, vmos2band->n_int)) )
  {
    (void) fprintf(stderr, "lvmos2band Failed\n");
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
(void) writeimage(vmos2band->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmos2band 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmos2band :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConverts a mosaic input image to an output  image  in  which\n");
	fprintf(stderr, "\teach  subimage of the input mosaic constitutes a band of the\n");
	fprintf(stderr, "\toutput image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-r  number of rows in each subimage (must be same for all subimages)  (integer, >= 0)\n");
	fprintf(stderr,"\t-c  number of columns in each subimage (must be same for all subimages)  (integer, >= 0)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-bs]  Subimage border size in pixels (inner borders) (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-bm]  Mosaic image border size in pixels (outer border) (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-x]  Horzontal index of first subimage (will be first band) (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-y]  Vertical index of first subimage (will be first band) (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-s]  Number of subimages to skip (periodic) when putting subimages into band format (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-n]  Number of subimages to be put into band format (integer, >= 0) [1]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmos2band\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmos2band\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmos2band.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmos2band.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmos2band
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows in each subimage (must be same for all subimages) \n        {integer, >= 0}: "; 
char	*c_pstr = 
	"\nEnter: (c) number of columns in each subimage (must be same for all subimages) \n        {integer, >= 0}: "; 
char	*bs_pstr = 
	"\nEnter: (bs) Subimage border size in pixels (inner borders) \n        {integer, >= 0 [0] }: "; 
char	*bm_pstr = 
	"\nEnter: (bm) Mosaic image border size in pixels (outer border) \n        {integer, >= 0 [0] }: "; 
char	*x_pstr = 
	"\nEnter: (x) Horzontal index of first subimage (will be first band) \n        {integer, >= 0 [0] }: "; 
char	*y_pstr = 
	"\nEnter: (y) Vertical index of first subimage (will be first band) \n        {integer, >= 0 [0] }: "; 
char	*s_pstr = 
	"\nEnter: (s) Number of subimages to skip (periodic) when putting subimages into band format \n        {integer, >= 0 [0] }: "; 
char	*n_pstr = 
	"\nEnter: (n) Number of subimages to be put into band format \n        {integer, >= 0 [1] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmos2band", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmos2band.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmos2band: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmos2band.ans");
		}

	     }

	}

	/*
	 * allocate the vmos2band structure
	 */
	vmos2band = (vmos2band_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmos2band_struct));

	/*
	 * get required arguments for vmos2band
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmos2band->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vmos2band->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmos2band->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vmos2band->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vmos2band->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmos2band->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmos2band->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmos2band->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmos2band->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmos2band->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmos2band->r_flag = vget_int(fid, prompt_flag,
			"-r", r_pstr, &(vmos2band->r_int),
			16, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmos2band->r_flag))
		{
		    fprintf(stderr, "\t\tr is required, please re-enter: \n");
		    vmos2band->r_flag = vget_int(fid, prompt_flag,
		    "-r", r_pstr, &(vmos2band->r_int),
		    16, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-r' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmos2band->c_flag = vget_int(fid, prompt_flag,
			"-c", c_pstr, &(vmos2band->c_int),
			16, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmos2band->c_flag))
		{
		    fprintf(stderr, "\t\tc is required, please re-enter: \n");
		    vmos2band->c_flag = vget_int(fid, prompt_flag,
		    "-c", c_pstr, &(vmos2band->c_int),
		    16, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-c' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vmos2band
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vmos2band->bs_flag = vget_int(fid, prompt_flag,
	"-bs", bs_pstr, &(vmos2band->bs_int),
	0, 1, 1);

	vmos2band->bm_flag = vget_int(fid, prompt_flag,
	"-bm", bm_pstr, &(vmos2band->bm_int),
	0, 1, 1);

	vmos2band->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(vmos2band->x_int),
	0, 1, 1);

	vmos2band->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(vmos2band->y_int),
	0, 1, 1);

	vmos2band->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(vmos2band->s_int),
	0, 1, 1);

	vmos2band->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(vmos2band->n_int),
	1, 1, 1);


}



