 /*
  * Khoros: $Id: vstats.h,v 1.2 1991/12/18 09:28:14 dkhoros Exp $
  */

 /*
  * $Log: vstats.h,v $
 * Revision 1.2  1991/12/18  09:28:14  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vstats.h
 >>>>            Author: Donna Koechner, John Rasure
 >>>> Date Last Updated: Fri Nov  8 15:26:46 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vstats_h_
#define _vstats_h_

#include "vinclude.h"


/* -include_includes */
#include "vipl/lvstats.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vstats Argument Structure
*
****************************************************************/

typedef struct _vstats  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  statistics operation masking image (Optional infile)
 */
char	*m_file;	/* statistics operation masking image FILENAME */
int	 m_flag;	/* statistics operation masking image FLAG */

/*
 *  output ASCII file (Optional outfile)
 */
char	*f_file;	/* output ASCII file FILENAME */
int	 f_flag;	/* output ASCII file FLAG */

/*
 *  VIFF format output file (Optional outfile)
 */
char	*o_file;	/* VIFF format output file FILENAME */
int	 o_flag;	/* VIFF format output file FLAG */

/*
 *  if yes, all stats saved (Optional logical)
 */
int	 all_logic;	/* if yes, all stats saved LOGIC */
int	 all_flag;  	/* if yes, all stats saved FLAG */

/*
 *  if yes, mean is a band of output (Optional logical)
 */
int	 mu_logic;	/* if yes, mean is a band of output LOGIC */
int	 mu_flag;  	/* if yes, mean is a band of output FLAG */

/*
 *  if yes, variance is a band of output (Optional logical)
 */
int	 var_logic;	/* if yes, variance is a band of output LOGIC */
int	 var_flag;  	/* if yes, variance is a band of output FLAG */

/*
 *  if yes, std deviation is a band of output (Optional logical)
 */
int	 sd_logic;	/* if yes, std deviation is a band of output LOGIC */
int	 sd_flag;  	/* if yes, std deviation is a band of output FLAG */

/*
 *  if yes, rms is a band of output (Optional logical)
 */
int	 rms_logic;	/* if yes, rms is a band of output LOGIC */
int	 rms_flag;  	/* if yes, rms is a band of output FLAG */

/*
 *  if yes, maximum value is a band of output (Optional logical)
 */
int	 vmax_logic;	/* if yes, maximum value is a band of output LOGIC */
int	 vmax_flag;  	/* if yes, maximum value is a band of output FLAG */

/*
 *  if yes, x coord of max value is a band of output (Optional logical)
 */
int	 xmax_logic;	/* if yes, x coord of max value is a band of output LOGIC */
int	 xmax_flag;  	/* if yes, x coord of max value is a band of output FLAG */

/*
 *  if yes, y coord of max value is a band of output (Optional logical)
 */
int	 ymax_logic;	/* if yes, y coord of max value is a band of output LOGIC */
int	 ymax_flag;  	/* if yes, y coord of max value is a band of output FLAG */

/*
 *  if yes, minimum value is a band of output (Optional logical)
 */
int	 vmin_logic;	/* if yes, minimum value is a band of output LOGIC */
int	 vmin_flag;  	/* if yes, minimum value is a band of output FLAG */

/*
 *  if yes, x coord of min value is a band of output (Optional logical)
 */
int	 xmin_logic;	/* if yes, x coord of min value is a band of output LOGIC */
int	 xmin_flag;  	/* if yes, x coord of min value is a band of output FLAG */

/*
 *  if yes, y coord of min value is a band of output (Optional logical)
 */
int	 ymin_logic;	/* if yes, y coord of min value is a band of output LOGIC */
int	 ymin_flag;  	/* if yes, y coord of min value is a band of output FLAG */

/*
 *  if yes, integral value is a band of output (Optional logical)
 */
int	 in_logic;	/* if yes, integral value is a band of output LOGIC */
int	 in_flag;  	/* if yes, integral value is a band of output FLAG */

/*
 *  if yes, pos part of integral is a band of output (Optional logical)
 */
int	 pin_logic;	/* if yes, pos part of integral is a band of output LOGIC */
int	 pin_flag;  	/* if yes, pos part of integral is a band of output FLAG */

/*
 *  if yes, neg part of integral is a band of output (Optional logical)
 */
int	 nin_logic;	/* if yes, neg part of integral is a band of output LOGIC */
int	 nin_flag;  	/* if yes, neg part of integral is a band of output FLAG */

/*
 *  if yes, num contributing pts is a band of output (Optional logical)
 */
int	 pts_logic;	/* if yes, num contributing pts is a band of output LOGIC */
int	 pts_flag;  	/* if yes, num contributing pts is a band of output FLAG */

/*
 *  if yes, num positive pts is a band of output (Optional logical)
 */
int	 ppts_logic;	/* if yes, num positive pts is a band of output LOGIC */
int	 ppts_flag;  	/* if yes, num positive pts is a band of output FLAG */

/*
 *  if yes, num negative pts is a band of output (Optional logical)
 */
int	 npts_logic;	/* if yes, num negative pts is a band of output LOGIC */
int	 npts_flag;  	/* if yes, num negative pts is a band of output FLAG */

/*
 *  if yes, skewness is a band of output (Optional logical)
 */
int	 sk_logic;	/* if yes, skewness is a band of output LOGIC */
int	 sk_flag;  	/* if yes, skewness is a band of output FLAG */

/*
 *  if yes, kurtosis is a band of output (Optional logical)
 */
int	 kur_logic;	/* if yes, kurtosis is a band of output LOGIC */
int	 kur_flag;  	/* if yes, kurtosis is a band of output FLAG */

/*
 *  if yes, entropy is a band of output (Optional logical)
 */
int	 ent_logic;	/* if yes, entropy is a band of output LOGIC */
int	 ent_flag;  	/* if yes, entropy is a band of output FLAG */

/*
 *  if yes, contrast is a band of output (Optional logical)
 */
int	 con_logic;	/* if yes, contrast is a band of output LOGIC */
int	 con_flag;  	/* if yes, contrast is a band of output FLAG */

/*
 *  if yes, Compute each data band statistics separately (Optional logical)
 */
int	 b_logic;	/* if yes, Compute each data band statistics separately LOGIC */
int	 b_flag;  	/* if yes, Compute each data band statistics separately FLAG */

}  vstats_struct;

vstats_struct *vstats;

/* -include_additions */
#define         ALL_OPTS        20
/* -include_additions_end */

/* -include_macros */
#define READINPUT(img1) \
        if ((img1 = readimage(vstats->i_file)) == NULL) exit(1)

#define READMASK(img2) \
        if (vstats->m_flag) img2 = readimage(vstats->m_file); \
        else img2 = NULL; \
        if (vstats->m_flag && (img2 == NULL)) exit(1)

#define CHECKINPUT(program, img1) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE)

#define MATCHINPUT(program, img1, img2) \
        if(vstats->m_flag) \
        { \
        (void) match_num_images(program,img1,img2,TRUE); \
        (void) match_num_bands(program,img1,img2,TRUE); \
        (void) match_map_enable(program,img1,img2,TRUE); \
        (void) matchsize(program,img1,img2,TRUE); \
        (void) matchtype(program,img1,img2,TRUE); \
        }

/* -include_macros_end */

#endif
