 /*
  * Khoros: $Id: vmapxfer.c,v 1.1 1991/05/10 15:50:36 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmapxfer.c,v 1.1 1991/05/10 15:50:36 khoros Exp $";
#endif

 /*
  * $Log: vmapxfer.c,v $
 * Revision 1.1  1991/05/10  15:50:36  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmapxfer.c
 >>>>
 >>>>      Program Name: vmapxfer
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Transfers the Map from one image to another
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer, Scott Wilson
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:38:02 1991
 >>>>
 >>>>          Routines: main- the main program for vmapxfer
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmapxfer.h"


/****************************************************************
 *
 * Routine Name:  main program for vmapxfer
 *
 *       Input:  
 *          -i1  Input Image to receive map 
 *          -i2  input image to extract map from 
 *          -o  output image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *image2, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

READINPUT1 (image);
READINPUT2 (image2);
CHECKINPUT1 (program, image);
CHECKINPUT2 (program, image2);
/* -main_before_lib_call_end */

/* -main_library_call */
  /* Call the lib routine for the map transfer */

if(! lvmapxfer(image, image2))
 {
   (void) fprintf(stderr, "lvmapxfer Failed\\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vmapxfer->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmapxfer 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmapxfer :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tTransfers the Map from one image to another\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  Input Image to receive map  (infile)\n");
	fprintf(stderr,"\t-i2  input image to extract map from  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmapxfer\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmapxfer\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmapxfer.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmapxfer.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmapxfer
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) Input Image to receive map \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input image to extract map from \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmapxfer", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmapxfer.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmapxfer: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmapxfer.ans");
		}

	     }

	}

	/*
	 * allocate the vmapxfer structure
	 */
	vmapxfer = (vmapxfer_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmapxfer_struct));

	/*
	 * get required arguments for vmapxfer
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmapxfer->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vmapxfer->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmapxfer->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vmapxfer->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vmapxfer->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmapxfer->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vmapxfer->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmapxfer->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vmapxfer->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vmapxfer->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmapxfer->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmapxfer->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmapxfer->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmapxfer->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmapxfer->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



