 /*
  * Khoros: $Id: vremmap.c,v 1.1 1991/05/10 15:50:40 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vremmap.c,v 1.1 1991/05/10 15:50:40 khoros Exp $";
#endif

 /*
  * $Log: vremmap.c,v $
 * Revision 1.1  1991/05/10  15:50:40  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vremmap.c
 >>>>
 >>>>      Program Name: vremmap
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Removes the map from an image
 >>>>	
 >>>>	
 >>>>            Author: Pascal ADAM
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:38:16 1991
 >>>>
 >>>>          Routines: main- the main program for vremmap
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vremmap.h"


/****************************************************************
 *
 * Routine Name:  main program for vremmap
 *
 *       Input:  
 *         -i  input image filename 
 *         -o  output image filename 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    image = readimage(vremmap->i_file);
    if (image == NULL) exit(1);                   /* Quit if bad image */

    proper_num_images(program, image, 1, TRUE);
    if (proper_map_scheme(program, image, VFF_MS_NONE, FALSE))
    {
        fprintf(stderr, "\n%s, ERROR Can not remove the image map.\n",program);
        fprintf(stderr, "               This image does not contain a map\n");
        exit(1);
    }

/* -main_before_lib_call_end */

/* -main_library_call */
        if (! (lvremmap(image)))
            exit(1);

/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vremmap->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vremmap 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vremmap :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tRemoves the map from an image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vremmap\n");
	fprintf(stderr, "\t[-U] Gives the usage for vremmap\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vremmap.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vremmap.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vremmap
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vremmap", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vremmap.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vremmap: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vremmap.ans");
		}

	     }

	}

	/*
	 * allocate the vremmap structure
	 */
	vremmap = (vremmap_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vremmap_struct));

	/*
	 * get required arguments for vremmap
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vremmap->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vremmap->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vremmap->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vremmap->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vremmap->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vremmap->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vremmap->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vremmap->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vremmap->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vremmap->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



