 /*
  * Khoros: $Id: vpostscr.c,v 1.2 1991/12/18 09:36:39 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vpostscr.c,v 1.2 1991/12/18 09:36:39 dkhoros Exp $";
#endif

 /*
  * $Log: vpostscr.c,v $
 * Revision 1.2  1991/12/18  09:36:39  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vpostscr.c
 >>>>
 >>>>      Program Name: vpostscr
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Format  a  Khoros  image  in  Postscript,  suitable  for   a
 >>>>	LaserWriter
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson, Mark Young
 >>>>
 >>>> Date Last Updated: Fri Dec  6 23:30:25 1991
 >>>>
 >>>>          Routines: main- the main program for vpostscr
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vpostscr.h"


/****************************************************************
 *
 * Routine Name:  main program for vpostscr
 *
 *       Input:  
 *          -i  input image filename 
 *
 *
 *          [-w] width of image in inches  (0.100 < value < 11.000)
 *          [-h] height of image in inches  (0.100 < value < 11.000)
 *          [-x] x offset in inches from upper left corner  (0.000 < value < 10.000)
 *          [-y] y offset in inches from upper left corner  (0.000 < value < 10.000)
 *          [-p] Print photonegative
 *          [-c] Force page output
 *          [-s] Enable color-to-grey conversion
 *          [-l] Print landscape mode
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        image = readimage(vpostscr->i_file);
        if (image == NULL) exit(1);                 /* Quit if bad image */

        proper_num_images(program,image,1,TRUE);
        if (!proper_num_bands(program,image,1, FALSE) &&
            !proper_num_bands(program,image,3, FALSE))
          {
            fprintf(stderr,"vpostscr: Image must have either 1 or 3 bands of data\n");
            exit(1);
          }
        if (propertype(program,image,VFF_TYP_2_BYTE,FALSE) ||
            propertype(program,image,VFF_TYP_4_BYTE,FALSE) ||
            propertype(program,image,VFF_TYP_FLOAT,FALSE) ||
            propertype(program,image,VFF_TYP_COMPLEX,FALSE)) 
          {
            fprintf(stderr, "Image data type should be BIT or BYTE\n");
            exit(1);
          }

        if (vpostscr->s_logic == 1)
          {
            if (image->map_enable == VFF_MAP_FORCE &&
                image->map_scheme == VFF_MS_ONEPERBAND ||
                image->map_scheme == VFF_MS_SHARED &&
                image->map_row_size == 3 &&
                image->map_storage_type == VFF_MAPTYP_1_BYTE)
                  {
                    if(!lvmsquish(image, TRUE, 1))
                      {
                        fprintf(stderr, "lvmsquish Failed\n");
                        exit(1);
                      }
                  }
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(!lvpostscr(stdout,image,
                      vpostscr->c_logic, vpostscr->p_logic,
                      vpostscr->w_flag, vpostscr->h_flag,
                      vpostscr->x_flag, vpostscr->y_flag,
                      vpostscr->w_float, vpostscr->h_float,
                      vpostscr->x_float, vpostscr->y_float,
                      vpostscr->l_logic))
          {
            fprintf(stderr, "lvpostscr Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vpostscr 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vpostscr :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tFormat  a  Khoros  image  in  Postscript,  suitable  for   a\n");
	fprintf(stderr, "\tLaserWriter\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-w]  width of image in inches (float,  0.100 to 11.000) [4]\n");
	fprintf(stderr,"\t[-h]  height of image in inches (float,  0.100 to 11.000) [4]\n");
	fprintf(stderr,"\t[-x]  x offset in inches from upper left corner (float,  0.000 to 10.000) [0]\n");
	fprintf(stderr,"\t[-y]  y offset in inches from upper left corner (float,  0.000 to 10.000) [0]\n");
	fprintf(stderr,"\t[-p]  Print photonegative (boolean) [false]\n");
	fprintf(stderr,"\t[-c]  Force page output (boolean) [true]\n");
	fprintf(stderr,"\t[-s]  Enable color-to-grey conversion (boolean) [true]\n");
	fprintf(stderr,"\t[-l]  Print landscape mode (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vpostscr\n");
	fprintf(stderr, "\t[-U] Gives the usage for vpostscr\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vpostscr.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vpostscr.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vpostscr
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*w_pstr = 
	"\nEnter: (w) width of image in inches \n        {float,  0.100 to 11.000 [4.000000] }: "; 
char	*h_pstr = 
	"\nEnter: (h) height of image in inches \n        {float,  0.100 to 11.000 [4.000000] }: "; 
char	*x_pstr = 
	"\nEnter: (x) x offset in inches from upper left corner \n        {float,  0.000 to 10.000 [0.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y offset in inches from upper left corner \n        {float,  0.000 to 10.000 [0.000000] }: "; 
char	*p_pstr = 
	"\nEnter: (p) Print photonegative \n        {boolean, (y/n)  [no] }: "; 
char	*c_pstr = 
	"\nEnter: (c) Force page output \n        {boolean, (y/n)  [yes] }: "; 
char	*s_pstr = 
	"\nEnter: (s) Enable color-to-grey conversion \n        {boolean, (y/n)  [yes] }: "; 
char	*l_pstr = 
	"\nEnter: (l) Print landscape mode \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vpostscr", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vpostscr.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vpostscr: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vpostscr.ans");
		}

	     }

	}

	/*
	 * allocate the vpostscr structure
	 */
	vpostscr = (vpostscr_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vpostscr_struct));

	/*
	 * get required arguments for vpostscr
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vpostscr->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vpostscr->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpostscr->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vpostscr->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vpostscr->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vpostscr
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vpostscr->w_flag = vget_float(fid, prompt_flag,
	"-w", w_pstr, &(vpostscr->w_float),
	4.000000, 0.100000, 11.000000);

	vpostscr->h_flag = vget_float(fid, prompt_flag,
	"-h", h_pstr, &(vpostscr->h_float),
	4.000000, 0.100000, 11.000000);

	vpostscr->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vpostscr->x_float),
	0.000000, 0.000000, 10.000000);

	vpostscr->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vpostscr->y_float),
	0.000000, 0.000000, 10.000000);

	vpostscr->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(vpostscr->p_logic), 0);

	vpostscr->c_flag = vget_logic(fid, prompt_flag,
	"-c", c_pstr, &(vpostscr->c_logic), 1);

	vpostscr->s_flag = vget_logic(fid, prompt_flag,
	"-s", s_pstr, &(vpostscr->s_logic), 1);

	vpostscr->l_flag = vget_logic(fid, prompt_flag,
	"-l", l_pstr, &(vpostscr->l_logic), 0);


}



