 /*
  * Khoros: $Id: search.c,v 1.4 1992/03/20 22:48:09 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: search.c,v 1.4 1992/03/20 22:48:09 dkhoros Exp $";
#endif

 /*
  * $Log: search.c,v $
 * Revision 1.4  1992/03/20  22:48:09  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                Form Tree Searching Routines           <<<<
   >>>>                                                       <<<<
   >>>>    All the following routines search the form tree    <<<<
   >>>>    for a particular item, and return the item in      <<<<
   >>>>    question to the caller.  Utility routines called   <<<<
   >>>>    from various places throughout xvforms.            <<<<
   >>>>                                                       <<<<
   >>>>                xvf_sel_search()                       <<<<
   >>>>                xvf_guide_search()                     <<<<
   >>>>                xvf_pane_search()                      <<<<
   >>>>                xvf_subform_search()                   <<<<
   >>>>                xvf_subform_button_search()            <<<<
   >>>>                xvf_find_sels_subform()                <<<<
   >>>>                xvf_find_sels_guide()                  <<<<
   >>>>                xvf_search_sel_guide()                 <<<<
   >>>>                xvf_search_sel_subform_action()        <<<<
   >>>>                xvf_search_sel_master_action()         <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */




/************************************************************
*
*  Routine Name: xvf_sel_search
*
*      Purpose:  searches for a particular selection in the
*		 form tree based on the provided index as the key
*
*        Input:  formptr - pointer to the subform tree
*		 index   - desired key 
*
*       Output:  pointer to the correct selection, or
*		 NULL if a selection with the desired index could
*		 not be found
*
*    Called By:  run_form
*
*   Written By:  Stephanie Hallett and Danielle Argiro
*
*************************************************************/


xvf_selection *xvf_sel_search(formptr, index)

xvf_form *formptr;
int	  index;
{
	xvf_sub_form *subform;
	xvf_selection *selection;
	xvf_guide_button *guide;
	xvf_selection *toggle;

	subform = formptr->subform;
	while (subform != NULL)
	{
	     guide = subform->guide_button;
	     while (guide != NULL) 
	     {
	         if (guide->pane != NULL)
	         {
		     selection = guide->pane->sel_list;
	   
	             while (selection != NULL) 
	             {
		         if (selection->index == index)
		             return(selection);
		         else if (selection->toggle_next != NULL)
		         {
			     toggle = selection->toggle_next;

			     while(toggle != NULL)
			     {
			         if (toggle->index == index)
				     return(toggle);
			         toggle = toggle->next;
			     }
		         }
		         selection = selection->next;
	              }
	        }
	        guide = guide->next_button;
	     }
	     subform = subform->next_subform;
	}
	return(NULL);
}


/************************************************************
*
*  Routine Name: xvf_variable_sel_search
*
*      Purpose:  searches for a particular selection in the
*		 form tree based on the provided variable as the key
*
*        Input:  formptr - pointer to the subform tree
*		 variable - desired variable 
*
*       Output:  pointer to the correct selection, or
*		 NULL if a selection with the desired variable could
*		 not be found
*
*   Written By:  Danielle Argiro
*
*************************************************************/


xvf_selection *xvf_variable_sel_search(formptr, variable)

xvf_form *formptr;
char	 *variable;
{
	Line_Info line_info;
	xvf_sub_form *subform;
	xvf_selection *selection;
	xvf_guide_button *guide;
	xvf_selection *toggle;
	int index;

	xvf_clear_line_info(&line_info);

	subform = formptr->subform;
	while (subform != NULL)
	{
	     guide = subform->guide_button;
	     while (guide != NULL) 
	     {
	         if (guide->pane != NULL)
	         {
		     selection = guide->pane->sel_list;
	   
	             while (selection != NULL) 
	             {
		         xvf_gen_parse(formptr->db, selection->index, 
				       &line_info);
		         if (VStrcmp(variable, line_info.variable)==0)
		             return(selection);
		         selection = selection->next;
	             }
	        }
	        guide = guide->next_button;
	     }
	     subform = subform->next_subform;
	}
	return(NULL);
}

/************************************************************
*
*  Routine Name: xvf_sel_search_subform
*
*      Purpose:  searches for a particular selection in the
*		 subform branch based on the provided index as the key
*
*        Input:  subformptr - pointer to the subform tree
*		 index      - desired key 
*
*       Output:  pointer to the correct selection, or
*		 NULL if a selection with the desired index could
*		 not be found
*
*    Called By:  xvips
*
*   Written By:  Stephanie Hallett and Danielle Argiro
*
*************************************************************/


xvf_selection *xvf_sel_search_subform(subform, index)

xvf_sub_form *subform;
int	  index;
{
	xvf_selection *selection;
	xvf_guide_button *guide;
	xvf_selection *toggle;

	guide = subform->guide_button;
	while (guide != NULL) 
	{
	    if (guide->pane != NULL)
	    {
	       selection = guide->pane->sel_list;
	       while (selection != NULL) 
	       {
		  if (selection->index == index)
		     return(selection);
		  else if (selection->toggle_next != NULL)
		  {
		     toggle = selection->toggle_next;

		     while(toggle != NULL)
		     {
		        if (toggle->index == index)
		           return(toggle);
		        toggle = toggle->next;
		     }
		  }
		  selection = selection->next;
	       }
	    }
	    guide = guide->next_button;
	}
	return(NULL);
}
	
	
/************************************************************
*
*  Routine Name: xvf_guide_search
*
*      Purpose:  searches for a particular guidebutton in the
*		 form tree based on the provided index of (-g) line
*		 as the key
*
*        Input:  formptr - pointer to the form tree
*		 index   - desired key 
*
*       Output:  pointer to the correct selection, or
*		 NULL if a selection with the desired index could
*		 not be found
*
*    Called By:  
*
*   Written By:  Stephanie Hallett and Danielle Argiro
*
*************************************************************/


xvf_guide_button *xvf_guide_search(formptr, index)

xvf_form *formptr;
int	  index;
{
	xvf_sub_form *subform;
	xvf_guide_button *guide;

	subform = formptr->subform;
	while (subform != NULL)
	{
	     guide = subform->guide_button;
	     while (guide != NULL) 
	     {
	         if (guide->index == index) return(guide);
	         guide = guide->next_button;
	     }
	     subform = subform->next_subform;
	}
	return(NULL);
}
	
	   
	
/************************************************************
*
*  Routine Name: xvf_pane_search
*
*      Purpose:  searches for a particular pane in the
*		 form tree based on the provided index of (-P) line
*		 as the key
*
*        Input:  formptr - pointer to the subform tree
*		 index   - desired key 
*
*       Output:  pointer to the correct selection, or
*		 NULL if a selection with the desired index could
*		 not be found
*
*   Written By:  Stephanie Hallett and Danielle Argiro
*
*************************************************************/


xvf_pane *xvf_pane_search(formptr, index)

xvf_form *formptr;
int	  index;
{
	xvf_sub_form *subform;
	xvf_guide_button *guide;
        
	subform = formptr->subform;
	while (subform != NULL)
	{
	     guide = subform->guide_button;
	     while (guide != NULL) 
	     {
	         if (guide->pane != NULL)
	         {
		     if (guide->pane->index == index) return(guide->pane);
	         }
	        guide = guide->next_button;
	     }
	     subform = subform->next_subform;
	}
	return(NULL);
}
	
/************************************************************
*
*  Routine Name: xvf_subform_search
*
*      Purpose:  searches for a particular subform in the
*		 form tree based on the provided index of the (-M) 
*		 line as the key
*
*        Input:  formptr - pointer to the form tree
*		 index   - desired key 
*
*       Output:  pointer to the correct selection, or
*		 NULL if a selection with the desired index could
*		 not be found
*
*    Called By:  
*
*   Written By:  Stephanie Hallett and Danielle Argiro
*
*************************************************************/


xvf_sub_form *xvf_subform_search(formptr, index)

xvf_form *formptr;
int	  index;
{
	xvf_sub_form *subform;

	subform = formptr->subform;
	while (subform != NULL)
	{
	     if ((subform->index == index) ||
		 (subform->button_index == index))
		   return(subform);
	     subform = subform->next_subform;
	}
	return(NULL);
}
	
	
	
/************************************************************
*
*  Routine Name: xvf_subform_button_search
*
*      Purpose:  searches for a particular subform button in the
*		 form tree based on the provided index of the as the key
*
*        Input:  formptr - pointer to the form tree
*		 index   - desired key 
*
*       Output:  pointer to the correct selection, or
*		 NULL if a selection with the desired index could
*		 not be found
*
*    Called By:  
*
*   Written By:  Stephanie Hallett and Danielle Argiro
*
*************************************************************/


xvf_sub_form *xvf_subform_button_search(formptr, index)

xvf_form *formptr;
int	  index;
{
	xvf_sub_form *subform;

	subform = formptr->subform;
	while (subform != NULL)
	{
	     if (subform->button_index == index) return(subform);
	     subform = subform->next_subform;
	}
	return(NULL);
}
	


/************************************************************
*
*  Routine Name: xvf_find_sels_subform
*
*      Purpose:  searches for a particular selection in the
*		 form tree based on the provided index as the key.
*		 returns the subform on which the selection is found.
*
*        Input:  formptr - pointer to the subform tree
*		 index   - desired key 
*
*       Output:  pointer to the correct subform, or
*		 NULL if a selection with the desired index could
*		 not be found
*
*    Called By:  run_form
*
*   Written By:  Stephanie Hallett and Danielle Argiro
*
*************************************************************/


xvf_sub_form *xvf_find_sels_subform(formptr, index)

xvf_form *formptr;
int	  index;
{
	xvf_sub_form *subform;
	xvf_selection *selection;
	xvf_guide_button *guide;
	xvf_selection *toggle;

	subform = formptr->subform;
	while (subform != NULL)
	{
	     if ((subform->index == index) || 
		 (subform->button_index == index) ||
		 (subform->guide_index == index))
		return(subform);

	     guide = subform->guide_button;
	     while (guide != NULL) 
	     {
		 if (guide->index == index)
		    return(subform);
	         else if (guide->pane != NULL)
	         {
		     if (guide->pane->index == index)
			 return(subform);

		     selection = guide->pane->sel_list;
	   
	             while (selection != NULL) 
	             {
		         if (selection->index == index)
		             return(subform);
		         else if (selection->toggle_next != NULL)
		         {
			     toggle = selection->toggle_next;

			     while(toggle != NULL)
			     {
			         if (toggle->index == index)
				     return(subform);
			         toggle = toggle->next;
			     }
		         }
		         selection = selection->next;
	              }
	        }
	        guide = guide->next_button;
	     }
	     subform = subform->next_subform;
	}
	return(NULL);
}
	


/************************************************************
*
*  Routine Name: xvf_find_sels_guide
*
*      Purpose:  searches for a particular guide in the
*		 form tree based on the provided index as the key.
*		 returns the guide pane on which the selection is found.
*
*        Input:  formptr - pointer to the subform tree
*		 index   - desired key 
*
*       Output:  pointer to the correct subform, or
*		 NULL if a selection with the desired index could
*		 not be found
*
*    Called By:  run_form
*
*   Written By:  Danielle Argiro
*
*************************************************************/


xvf_guide_button *xvf_find_sels_guide(formptr, index)

xvf_form *formptr;
int	  index;
{
	xvf_sub_form *subform;
	xvf_selection *selection;
	xvf_guide_button *guide;
	xvf_selection *toggle;

	subform = formptr->subform;
	while (subform != NULL)
	{
	     guide = subform->guide_button;
	     while (guide != NULL) 
	     {
		 if (guide->index == index)
		    return(guide);
	         else if (guide->pane != NULL)
	         {
		     selection = guide->pane->sel_list;
	   
	             while (selection != NULL) 
	             {
		         if (selection->toggle_next != NULL)
		         {
			     toggle = selection->toggle_next;

			     while(toggle != NULL)
			     {
			         if (toggle->index == index)
				     return(guide);
			         toggle = toggle->next;
			     }
		         }
		         selection = selection->next;
	              }
	        }
	        guide = guide->next_button;
	     }
	     subform = subform->next_subform;
	}
	return(NULL);
}
	
/************************************************************
*
*  Routine Name:  xvf_search_sel_guide(subform)
*
*      Purpose:   Searches a form for the "guide button"
*		  that is selected.  NULL will be returned
*		  if there is no -g guide button selected.
*
*        Input:   subform     - pointer to a subform tree.
*
*       Output:   gives back a pointer to the selected guide
*		  button's node in the tree.
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

xvf_guide_button *xvf_search_sel_guide(subform)
xvf_sub_form *subform;
{
   xvf_guide_button *guide;

   guide = subform->guide_button;

   while (guide != NULL)
   {
      if ((guide->type == GuideButton)&&(guide->selected==true))
	 return(guide);
      guide = guide->next_button;
   }

   return(NULL);
}
   

/************************************************************
*
*  Routine Name:  xvf_search_sel_subform_action(subform)
*
*      Purpose:   Searches a guide pane for the "subform
*		  action button" that is selected.  
*		  NULL will be returned if there is 
*		  no -m button selected.
*
*        Input:   subform     - pointer to a form tree.
*
*       Output:   gives back a pointer to the selected 
*  		  subform action button's guide button node in the tree.
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

xvf_guide_button *xvf_search_sel_subform_action(subform)
xvf_sub_form *subform;
{
   xvf_guide_button *guide;

   guide = subform->guide_button;

   while (guide != NULL)
   {
      if ((guide->type == SubformAction)&&(guide->selected==true))
	 return(guide);
      guide = guide->next_button;
   }

   return(NULL);
}
   

/************************************************************
*
*  Routine Name:  xvf_search_sel_master_action(form)
*
*      Purpose:   Searches a form for the "master
*		  action button" that is selected.  
*		  NULL will be returned if there is 
*		  no -n button selected.
*
*        Input:   form     - pointer to a form tree.
*
*       Output:   gives back a pointer to the selected 
*  		  master action button's node in the tree.
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

xvf_sub_form *xvf_search_sel_master_action(form)
xvf_form *form;
{
   xvf_sub_form *subform;

   subform = form->subform;

   while (subform != NULL)
   {
      if ((subform->type == MasterAction)&&(subform->selected==true))
	 return(subform);
      subform = subform->next_subform;
   }

   return(NULL);
}
