/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  node_pq.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#ifndef NODE_PQ_H
#define NODE_PQ_H

#include <LEDA/graph.h>


//------------------------------------------------------------------------------
// node priority queues
//------------------------------------------------------------------------------

#ifndef FHEAPH
#include <LEDA/f_heap.h>
#endif

#define node_pq(itype) name2(itype,node_pq)\

#define node_pqdeclare(itype)\
\
class node_pq(itype) : private f_heap{\
\
itype name2(itype,X);\
\
int cmp(GenPtr x, GenPtr y)  const\
                         { return compare(ACCESS(itype,x),ACCESS(itype,y)); }\
void print_key(GenPtr& x)   const { Print(ACCESS(itype,x)); }\
void clear_key(GenPtr& x)   const { Clear(ACCESS(itype,x)); }\
void copy_key(GenPtr& x)    const { x=Copy(ACCESS(itype,x));  }\
void print_inf(GenPtr& x)   const { Print(node(x));  }\
void clear_inf(GenPtr& x)   const { Clear(node(x));  }\
void copy_inf(GenPtr& x)    const { x=Copy(node(x));   }\
\
graph_array(node) I;\
\
public:\
 node_pq(itype)(const graph& G) { I.init(G,0); }\
~node_pq(itype)()               { I.clear(); }\
\
 void decrease_inf(node v, itype i)\
                      { f_heap::decrease_key(f_heap_item(I.inf(v)),Convert(i)); }\
 void insert(node v,itype i)\
                  { I.entry(v)=(GenPtr)f_heap::insert(Convert(i),GenPtr(v));}\
 void del(node v) { f_heap::del_item(f_heap_item(I.inf(v)));   }\
 node find_min()  { return (node)f_heap::inf(f_heap::find_min());   }\
 node del_min()   { node v = find_min(); f_heap::del_min(); return v; }\
 void clear()     { f_heap::clear(); }\
 int empty()      { return f_heap::empty(); }\
\
};

#endif
