/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  planar_map.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef PLANAR_MAPH
#define PLANAR_MAPH

#include <LEDA/graph.h>

class i_face;

typedef i_face* face;

class i_face {

friend class planar_map;

 edge      head;  // first edge of face
 list_item loc;   // location in F_list
 GenPtr       inf;   // user defined information

 planar_map*  g;     // face of (*g)


friend planar_map* graph_of(face f) { return f->g; }


 i_face(GenPtr x, planar_map* G) 
 { 
   inf = x ; 
   head = nil; 
   loc = nil; 
   g = G;
  }


  LEDA_MEMORY(i_face)

};

declare(list,face);

declare(node_array,int)


extern int STRAIGHT_LINE_EMBEDDING(graph& G, node_array(int)& xcoord,
                                            node_array(int)& ycoord);

class planar_map : public graph {

list(face)       F_list;

face  new_face(GenPtr i=0);
void  del_face(face f) { F_list.del(f->loc); delete f; }
face& get_face(edge e) { return (face&)(e->contents);  }
edge& get_rev(edge e)  { return (edge&)(e->adj_loc2);  }

virtual void copy_face_entry(GenPtr&)  const {}
virtual void init_face_entry(GenPtr&)  const {}
virtual void clear_face_entry(GenPtr&) const {}
virtual void print_face_entry(GenPtr&) const {}

public:


 planar_map(const graph&);
~planar_map();

void       init_entries();


list(node) adj_nodes(face)   const;
list(node) adj_nodes(node v) const { return graph::adj_nodes(v); }

list(edge) adj_edges(face)   const;
list(edge) adj_edges(node v) const { return graph::adj_edges(v); }

list(face) all_faces()       const { return F_list; }
list(face) adj_faces(node)   const;

face       adj_face(edge e)  const { return face(e->contents); }

list(edge) triangulate();

edge reverse(edge e)         const { return edge(e->adj_loc2); }

edge first_face_edge(face f) const { return f->head; }
edge succ_face_edge(edge e)  const { return cyclic_adj_succ(reverse(e)); } 
edge pred_face_edge(edge e)  const { return reverse(cyclic_adj_pred(e)); } 

edge next_face_edge(edge e)  const  
{ e = succ_face_edge(e);
  return (e==adj_face(e)->head) ? nil : e;
}

face first_face() const { return F_list.head(); }

face next_face(face f) const
{ list_item it = F_list.succ(f->loc);
  return (it) ? F_list.contents(it) : nil;
}


edge       new_edge(edge,edge,GenPtr=0);
void       del_edge(edge,GenPtr=0);

GenPtr& entry(face f)         { return f->inf; }
GenPtr& entry(node v)         { return graph::entry(v); }

GenPtr  inf(face f)     const { return f->inf; }
GenPtr  inf(node v)     const { return graph::inf(v); }

int        straight_line_embedding(node_array(int)& x, node_array(int)& y)
                                 { return STRAIGHT_LINE_EMBEDDING(*this,x,y); }


};


//------------------------------------------------------------------------------
// PLANAR_MAP: generic planar map
//------------------------------------------------------------------------------

#define PLANAR_MAP(vtype,ftype)   name3(vtype,ftype,PLANAR_MAP)

#define PLANAR_MAPdeclare2(vtype,ftype)\
\
class PLANAR_MAP(vtype,ftype) : public planar_map {\
\
vtype name2(vtype,X1);\
ftype name2(ftype,X2);\
\
void init_node_entry(GenPtr& x)  const { Init(name2(vtype,X1));\
                                          x=Copy(name2(vtype,X1)); }\
void init_face_entry(GenPtr& x)  const { Init(name2(ftype,X2));\
                                          x=Copy(name2(ftype,X2)); }\
\
void copy_node_entry(GenPtr& x)  const { x=Copy(ACCESS1(vtype,x)); }\
void copy_face_entry(GenPtr& x)  const { x=Copy(ACCESS2(ftype,x)); }\
\
void clear_node_entry(GenPtr& x) const { Clear(ACCESS1(vtype,x)); }\
void clear_face_entry(GenPtr& x) const { Clear(ACCESS2(ftype,x)); }\
\
public:\
\
   vtype  inf(node v)    const   { return ACCESS1(vtype,planar_map::inf(v)); }\
   ftype  inf(face f)    const   { return ACCESS2(ftype,planar_map::inf(f)); }\
   vtype& operator[] (node v)    { return entry(v); }\
   ftype& operator[] (face f)    { return entry(f); }\
   void   assign(node v,vtype a) { entry(v) = Copy(a); }\
   void   assign(face f,ftype a) { entry(f) = Copy(a); }\
\
   edge   new_edge(edge e1, edge e2)\
                          { return planar_map::new_edge(e1,e2,0); }\
   edge   new_edge(edge e1, edge e2, ftype a)\
                          { return planar_map::new_edge(e1,e2,Convert(a)); }\
\
void print_node(node v) const { cout << "["; Print(ACCESS1(vtype,entry(v))); cout << "]";}\
\
   PLANAR_MAP(vtype,ftype)(const GRAPH(vtype,ftype)& G) : ((graph&)G)   {}\
  ~PLANAR_MAP(vtype,ftype)()     { clear(); }\
\
};


#define forall_face_edges(e,F)\
for(e=graph_of(F)->first_face_edge(F); e; e=graph_of(F)->next_face_edge(e)) 

#define forall_faces(f,G)\
for(f=G.first_face(); f; f=G.next_face(f)) 



#endif PLANAR_MAPH
