/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  segment_set.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#ifndef SEGMENT_SET_H
#define SEGMENT_SET_H

#include <LEDA/seg_tree.h>
#include <LEDA/line.h>

typedef seg_tree_item seg_item;

declare(list,seg_item)

declare3(segment_tree,double,double,GenPtr)

//------------------------------------------------------------------------------
// SegmentSet: a dictionary for line segments  with a fixed orientation
//------------------------------------------------------------------------------

struct SegmentSet : public segment_tree(double,double,GenPtr) {

double alpha;           // orientation given by an angle
 
segment  key(seg_item);

seg_item insert(segment, GenPtr);
seg_item lookup(segment);
void     del(segment);

list(seg_item)  intersection(segment);
list(seg_item)  intersection(line);

 SegmentSet(double a=0)  { alpha =a; }
~SegmentSet()  {}
};

#define forall_seg_items(i,S) forall_seg_tree_items(i,S)


//------------------------------------------------------------------------------
// class segment_set: generic SegmentSet
//------------------------------------------------------------------------------

#define segment_set(itype) name2(itype,segment_set)
 
#define segment_setdeclare(itype)\
\
struct segment_set(itype) : public SegmentSet{\
\
itype name2(itype,X);\
\
itype inf(seg_item it)  { return ACCESS(itype,SegmentSet::inf(it));  }\
seg_item insert(segment s, itype i)   { return SegmentSet::insert(s,Copy(i));}\
void  change_inf(seg_item it,itype i) { SegmentSet::change_inf(it,Copy(i)); }\
\
segment_set(itype)(double a=0) : SegmentSet(a) {}\
~segment_set(itype)()  {}\
};
 
 
#endif
