#include <LEDA/graph.h>
#include <LEDA/graph_alg.h>

declare2(GRAPH,int,int);

void main()
{

GRAPH(int,int) G;

test_graph(G);

int a = read_int("a = ");
int b = read_int("b = ");

edge_array(int)  cost(G,0);
list(edge) el;
edge x;
int total;

init_random();
forall_edges(x,G) cost[x] = G[x] = random(a,b);

float T = used_time();

cout << "SPANNING_TREE:     ";
cout.flush();
el = SPANNING_TREE(G);
cout << string(" %4.2f sec    ",used_time(T));

total = 0;
forall(x,el)  total += cost[x];

if (Yes("Ausgabe? ")) 
 forall(x,el) { G.print_edge(x); newline; }

cout << string("total cost %d\n",total);


cout << "MIN_SPANNING_TREE: ";
cout.flush();
el = MIN_SPANNING_TREE(G,cost);
cout << string(" %4.2f sec    ",used_time(T));

total = 0;
forall(x,el)  total += cost[x];

if (Yes("Ausgabe? ")) 
 forall(x,el) { G.print_edge(x); newline; }

cout << string("total cost %d\n",total);

}
