#include <LEDA/graph_alg.h>
#include <LEDA/graph_edit.h>

declare2(UGRAPH,point,int)


window W;

void bold_edge(GRAPH(point,int)& G, edge e)
{ point p = G[source(e)];
  point q = G[target(e)];
  W.draw_edge(p,q);
  int save = W.set_line_width(5);
  W.draw_edge(p,q);
  W.set_line_width(save);
}

void unbold_edge(GRAPH(point,int)& G, edge e)
{ int save = W.set_line_width(5);
  point p = G[source(e)];
  point q = G[target(e)];
  W.draw_edge(p,q);
  W.set_line_width(save);
  W.draw_edge(p,q);
}

void show_edge_inf(GRAPH(point,int)& G, edge_array(int)& edge_num)
{ edge e;
  forall_edges(e,G)
  { point p = G[source(e)];
    point q = G[target(e)];
    W.draw_text((p.xcoord()+q.xcoord())/2, (p.ycoord()+q.ycoord())/2,
                  string("%d", edge_num[e]));
   }
 }

void show_edge_inf(UGRAPH(point,int)& G, edge_array(int)& edge_num)
{ edge e;
  forall_edges(e,G)
  { point p = G[source(e)];
    point q = G[target(e)];
    W.draw_text((p.xcoord()+q.xcoord())/2, (p.ycoord()+q.ycoord())/2,
                  string("%d", edge_num[e]));
   }
 }

void show_node_inf(GRAPH(point,int)& G, node_array(int)& node_num)
{ node v;
  forall_nodes(v,G)
  { W.draw_filled_node(G[v],blue);
    W.draw_ctext(G[v],string("%d",node_num[v]),white);
   }
}


void main()
{
  panel P("Graph Algorithms");


  list(string) menu;
  menu.append("topsort");
  menu.append("strongcomp");
  menu.append("bicomp");
  menu.append("matching");

  string alg = menu.head();

  P.string_item("choose algorithm:", alg, menu);

  P.button("graph_edit");
  P.button("run algorithm");
  P.button("quit");

  GRAPH(point,int)  G;
  node v;
  edge e;

  W.set_mode(xor_mode);
  W.set_node_width(12);

  for(;;)
  { 
    W.del_message();
    switch(P.open(0,0)) 
    {
      case 0: graph_edit(W,G);
              break;

      case 1: { if (alg == "bicomp")
                { W.message("BICONNECTED COMPONENTS");
                  UGRAPH(point,int) U = G;
                  edge_array(int) edge_num(U);
                  BICONNECTED_COMPONENTS(U,edge_num);
                  show_edge_inf(U,edge_num);
                  W.read_mouse();
                  show_edge_inf(U,edge_num);
                  break;
                 }
          
                if (alg == "strongcomp")
                { W.message("STRONG COMPONENTS");
                  node_array(int) node_num(G);
                  STRONG_COMPONENTS(G,node_num);
                  show_node_inf(G,node_num);
                  W.read_mouse();
                  show_node_inf(G,node_num);
                  break;
                 }

                if (alg == "topsort")
                { W.message("TOPSORT");
                  node_array(int) node_num(G);
                  TOPSORT(G,node_num);
                  show_node_inf(G,node_num);
                  W.read_mouse();
                  show_node_inf(G,node_num);
                  break;
                 }

                if (alg == "matching")
                { W.message("MAX_CARD_MATCHING");
                  list(edge) L = MAX_CARD_MATCHING(G);
                  forall(e,L) bold_edge(G,e);       
                  W.read_mouse();
                  forall(e,L) unbold_edge(G,e);       
                  break;
                 }

                W.acknowledge(string("Sorry, %s not implemented",alg));
                break;
          
               }

     case 2: exit(0);

              
   } //switch

  }

}
