/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _g_sort.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#include <LEDA/graph.h>

//--------------------------------------------------------------------------
// sorting
//--------------------------------------------------------------------------

static const graph_array(node)*  NA;
static const graph_array(edge)*  EA;
static const graph* GGG;

static int array_cmp_nodes(node& x, node& y) { return NA->cmp_entry(x,y); }
static int array_cmp_edges(edge& x, edge& y) { return EA->cmp_entry(x,y); }

static int graph_cmp_nodes(node& x, node& y){ return GGG->cmp_node_entry(x,y); }
static int graph_cmp_edges(edge& x, edge& y){ return GGG->cmp_edge_entry(x,y); }


void graph::sort_nodes(COMPARE(graph,node) f ) { V.sort(f); }

void graph::sort_edges(COMPARE(graph,edge) f)
{ E.sort(f);
  node v;
  forall(v,V) v->adj_edges.sort(f);
}

void graph::sort_nodes(const graph_array(node)& A) 
{ NA = &A; 
  sort_nodes(array_cmp_nodes); 
 }

void graph::sort_edges(const graph_array(edge)& A) 
{ EA = &A; 
  sort_edges(array_cmp_edges); 
 }


void graph::sort_nodes() 
{ GGG = this; 
  sort_nodes(graph_cmp_nodes); 
 }

void graph::sort_edges() 
{ GGG = this; 
  sort_edges(graph_cmp_edges); 
 }

