/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _dijkstra.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



/*******************************************************************************
*                                                                              *
*  DIJKSTRA  (single source shortest paths)                                    *
*                                                                              *
*******************************************************************************/



#include <LEDA/graph_alg.h>

#include <LEDA/node_pq.h>

declare(node_pq,int)


void DIJKSTRA(const graph& G, node s, const edge_array(int)&  cost, 
                                            node_array(int)&  dist,
                                            node_array(edge)& pred ) 
{
  /*
     Dijkstra's Algorithms for integer edge costs,
     computes single source shortest paths from node s for 
     a non-negative network (G,cost), computes for all nodes v:
     a) dist[v] = cost of shortest path from s to v
     b) pred[v] = predecessor edge of v in shortest paths tree
  */


  node_pq(int) PQ(G);

  int c;
  node u,v;                                                                    
  edge e;                                                                      
                                                                               
  forall_nodes(v,G)                                                            
    { pred[v] = 0;                                                             
      dist[v] = MAXINT;                                                      
      PQ.insert(v,dist[v]);
     }                                                                         

  dist[s] = 0;
  PQ.decrease_inf(s,0);                                               
                                                                               
  while (! PQ.empty())
   { u = PQ.del_min();
     if (dist[u] == MAXINT) break;

     forall_adj_edges(e,u)                                                    
        { v = target(e);                                                      
          c = dist[u] + cost[e];                                              
          if (c < dist[v])                                                    
           { dist[v] = c;                                                     
             pred[v] = e;                                                     
             PQ.decrease_inf(v,c);
            }                                                                 
         }                                                                    

    } // while                                                                

}



#ifndef __TURBOC__

// Dijkstra Algorithms for double valued edge costs 

declare(node_pq,double)

void DIJKSTRA(const graph& G, node s, const edge_array(double)&  cost, 
                                            node_array(double)&  dist,
                                            node_array(edge)& pred ) 

{ node_pq(double) PQ(G);

  double c;
  node u,v;                                                                    
  edge e;                                                                      
                                                                               
  forall_nodes(v,G)                                                            
    { pred[v] = 0;                                                             
      dist[v] = MAXDOUBLE;                                                      
      PQ.insert(v,dist[v]);
     }                                                                         

  dist[s] = 0;
  PQ.decrease_inf(s,0);                                               
                                                                               
  while (! PQ.empty())
   { u = PQ.del_min();
     if (dist[u] == MAXDOUBLE) break;

     forall_adj_edges(e,u)                                                    
        { v = target(e);                                                      
          c = dist[u] + cost[e];                                              
          if (c < dist[v])                                                    
           { dist[v] = c;                                                     
             pred[v] = e;                                                     
             PQ.decrease_inf(v,c);
            }                                                                 
         }                                                                    
    } // while                                                                

}


#endif
