/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _win_output.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/window.h>
#include <math.h>

#include "x_draw.h"


//------------------------------------------------------------------------------
// OUTPUT
//------------------------------------------------------------------------------

// pixels

void window::draw_pix(double x, double y, color c ) 
{ x_draw_pix(x,y,c); }

void window::draw_pix(point p, color c ) 
{ draw_pix(p.xcoord(),p.ycoord(),c); }


// points

void window::draw_point(double x0,double y0,color c)
{ x_draw_point(x0,y0,c); }

void window::draw_point(point p,color c)
{ draw_point(p.xcoord(),p.ycoord(),c); }

window& window::draw(point p, color c)
{ draw_point(p,c); 
  return *this;
 }


// segments

void window::draw_segment(double x1, double y1, double x2, double y2, color c )
{ x_draw_line(x1,y1,x2,y2,c); }

void window::draw_segment(point p, point q, color c )
{ window::draw_segment(p.xcoord(),p.ycoord(),q.xcoord(),q.ycoord(),c); }

void window::draw_segment(segment s, color c )
{ draw_segment(s.start(),s.end(),c); }

window& window::draw(segment s, color c)
{ draw_segment(s,c);
  return *this;
 }


// lines

void window::draw_line(segment s, color c )
{
  double a,x0,x1,y0,y1;

  if (s.vertical()) 
  { draw_vline(s.xcoord1(),c);
    return;
   }

  a  = s.slope();

  if (fabs(a) < 1)
  { x0 = xmin();
    x1 = xmax();
    //y0 = a*x0 + s.y_proj(0);
    //y1 = a*x1 + s.y_proj(0);
    y0 = s.y_proj(x0);
    y1 = s.y_proj(x1);
   }
  else
  { y0 = ymin();
    y1 = ymax();
    //x0 = y0/a + s.x_proj(0);
    //x1 = y1/a + s.x_proj(0);
    x0 = s.x_proj(y0);
    x1 = s.x_proj(y1);
   }

  x_draw_line(x0,y0,x1,y1,c);

}

void window::draw_line(double x1, double y1, double x2, double y2, color c )
{ draw_line(segment(x1,y1,x2,y2),c); }

void window::draw_line(point p, point q, color c) 
{ draw_line(segment(p,q),c); }


void window::draw_hline(double y, color c )
{ x_draw_line(x_draw_xmin,y,x_draw_xmax,y,c); }

void window::draw_vline(double x, color c )
{ x_draw_line(x,x_draw_ymin,x,x_draw_ymax,c); }




// nodes

void window::draw_node(double x0,double y0,color c) 
{ x_draw_node(x0,y0,c); }

void window::draw_node(point p, color c)
{ window::draw_node(p.xcoord(),p.ycoord(),c); }

void window::draw_filled_node(double x0,double y0,color c)
{ x_draw_filled_node(x0,y0,c); }

void window::draw_filled_node(point p, color c)
{ window::draw_filled_node(p.xcoord(),p.ycoord(),c); }

void window::draw_text_node(double x,double y,string s,color c)
{ x_draw_text_node(x,y,~s,c); }

void window::draw_text_node(point p ,string s,color c)
{ window::draw_text_node(p.xcoord(),p.ycoord(),~s,c); }

void window::draw_int_node(double x,double y,int i,color c)
{ x_draw_int_node(x,y,i,c); }

void window::draw_int_node(point p ,int i,color c)
{ window::draw_int_node(p.xcoord(),p.ycoord(),i,c); }


//circles

void window::draw_circle(double x,double y,double r,color c)
{ x_draw_circle(x,y,r,c); }

void window::draw_circle(point p,double r,color c)
{ x_draw_circle(p.xcoord(),p.ycoord(),r,c); }


//ellipses

void window::draw_ellipse(double x,double y,double a, double b, color c)
{ x_draw_ellipse(x,y,a,b,c); }

void window::draw_ellipse(point p, double a, double b, color c)
{ x_draw_ellipse(p.xcoord(),p.ycoord(),a,b,c); }



void window::draw_disc(double x,double y,double r,color c)
{ x_draw_filled_circle(x,y,r,c); }

void window::draw_disc(point p,double r,color c)
{ window::draw_disc(p.xcoord(),p.ycoord(),r,c); }


void window::draw_polygon(list(point) lp, color c)
{ int n = lp.length();
  double* X = new double[n];
  double* Y = new double[n];
  n = 0;
  point p;
  forall(p,lp) 
  { X[n] = p.xcoord();
    Y[n] = p.ycoord();
    n++;
   }
  x_draw_polygon(n,X,Y,c);
}

void window::draw_filled_polygon(list(point) lp, color c)
{ int n = lp.length();
  double* X = new double[n];
  double* Y = new double[n];
  n = 0;
  point p;
  forall(p,lp) 
  { X[n] = p.xcoord();
    Y[n] = p.ycoord();
    n++;
   }
  x_draw_filled_polygon(n,X,Y,c);
}



void window::draw_rectangle(double a, double  b, double c, double d, color col)
{ x_draw_rectangle(a,b,c,d,col); }

void window::draw_filled_rectangle(double a, double  b, double c, double d, color col)
{ x_draw_filled_rectangle(a,b,c,d,col); }


// miscellaneous

void window::copy_rect(double x1, double y1, double x2, double y2, double x, double y) 
{ x_draw_copy_rect(x1,y1,x2,y2,x,y); }


void window::clear(color c) { x_draw_clear(c); }

void window::show_window()  { x_show_window(); }


// text

void window::draw_text(double x, double y, string s, color c)
{ x_draw_text(x,y,~s,c); 
 }

void window::draw_text(point p, string s, color c)
{ window::draw_text(p.xcoord(),p.ycoord(),s,c);  
 }


void window::draw_ctext(double x, double y, string s, color c)
{ x_draw_ctext(x,y,~s,c); 
 }

void window::draw_ctext(point p, string s, color c)
{ window::draw_ctext(p.xcoord(),p.ycoord(),s,c); }


// functions

void window::plot_xy(double x0, double x1, draw_func_ptr f, color c)
{ x_draw_plot_xy(x0,x1,f,c); }

void window::plot_yx(double y0, double y1, draw_func_ptr f, color c)
{ x_draw_plot_yx(y0,y1,f,c); }



// messages

void window::message(string s) { x_draw_message(~s); }
void window::del_message()     { x_draw_del_messages(); }



// arrows

void window::draw_arrow(double x0, double y0, double x1, double y1, color c)
{ draw_arrow(point(x0,y0),point(x1,y1),c); }

void window::draw_arrow(point p, point q, color c)
{ draw_arrow(segment(p,q),c); }

void window::draw_arrow(segment s, color c)
{
  point p = s.start();
  point q = s.end();
  double alpha = s.angle()-M_PI; 

  double d = 2*((get_line_width()+1)/2)/scale();

  point l = q.translate(alpha+M_PI/6, 7*d);
  point m = q.translate(alpha,        4*d);
  point r = q.translate(alpha-M_PI/6, 7*d);

  list(point) L;

  L.append(q);
  L.append(l);
  L.append(m);
  L.append(r);

  draw_segment(p,m,c);
  draw_filled_polygon(L,c);
}



// edges


void window::draw_edge(double x1, double y1, double x2, double y2, color c)
{ draw_edge(point(x1,y1), point(x2,y2),c); }

void window::draw_edge(point p, point q, color c)
{ draw_edge(segment(p,q),c); }

void window::draw_edge(segment s, color c)
{ double alpha = s.angle();
  point p = s.start().translate(alpha,get_node_width()/x_draw_scale);
  point q = s.end().translate(alpha,-get_node_width()/x_draw_scale);
  draw_segment(p,q,c); 
}


void window::draw_edge_arrow(double x1,double y1,double x2,double y2,color c)
{ draw_edge_arrow(point(x1,y1), point(x2,y2),c); }

void window::draw_edge_arrow(point p, point q, color c)
{ draw_edge_arrow(segment(p,q),c); }

void window::draw_edge_arrow(segment s, color c)
{ double  alpha = s.angle();
  point p = s.start().translate(alpha,get_node_width()/x_draw_scale);
  point q = s.end().translate(alpha,-get_node_width()/x_draw_scale);
  draw_arrow(p,q,c);
}




#ifndef __TURBOC__

window& window::draw(line l, color c)
{ draw_line(l,c);
  return *this;
 }

window& window::draw(circle C,color c)
{ draw_circle(C,c); 
  return *this;
 }

window& window::draw(polygon P,color c)
{ draw_polygon(P,c); 
  return *this;
 }


void window::draw_line(line l, color c )
{
  double a,x0,x1,y0,y1;

  if (l.vertical()) 
  { draw_vline(l.x_proj(0),c);
    return;
   }

  a = l.slope();

  if (fabs(a) < 1)
  { x0 = xmin();
    x1 = xmax();
    y0 = l.y_proj(x0);
    y1 = l.y_proj(x1);
   }
  else
  { y0 = ymin();
    y1 = ymax();
    x0 = l.x_proj(y0);
    x1 = l.x_proj(y1);
   }

  x_draw_line(x0,y0,x1,y1,c);

}

void window::draw_circle(circle C,color c)
{ point p = C.center();
  double r = C.radius();
  x_draw_circle(p.xcoord(),p.ycoord(),r,c); 
 }

void window::draw_disc(circle C,color c)
{ draw_disc(C.center(),C.radius(),c); }


void window::draw_polygon(polygon P, color c )
{ draw_polygon(P.vertices(),c); }


void window::draw_filled_polygon(polygon P,color c )
{ draw_filled_polygon(P.vertices(),c); }


#endif

