/*
 *	Definitions for <A>GEMatrix
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)xgemat.cc	2.2	9/18/89
 */

#define NO_VECTOR_MATHFUN
#include "rw/<A>GEMatrix.h"

static const char SCCSid[] = "@(#)xgemat.cc	2.2 9/18/89";

<A>GEMatrix::<A>GEMatrix() :
    ()
{
  nrows = 0;
  ncols = 0;
}

<A>GEMatrix::<A>GEMatrix(int rows, int cols) :
    (rows*cols)
{
  nrows = rows;
  ncols = cols;
}

<A>GEMatrix::<A>GEMatrix(int rows, int cols, <T> initval) :
    (rows*cols, initval)
{
  nrows = rows;
  ncols = cols;
}

<A>GEMatrix::<A>GEMatrix(const <A>GEMatrix& m) :
    (*(<T>Vec*)&m)		// Cast necessary for g++ bug
{
  nrows = m.nrows;
  ncols = m.ncols;
}

<A>GEMatrix::<A>GEMatrix(const <T>* v, int rows, int cols) :
    (v, rows*cols)
{
  nrows = rows;
  ncols = cols;
}

<A>GEMatrix::<A>GEMatrix(const <T>Vec& v, int rows, int cols) :
    (v)
{
  nrows = rows;
  ncols = cols;
  assertLength(v);
}

<A>GEMatrix&
<A>GEMatrix::operator=(const <A>GEMatrix& m)
{
  // Copy the base class over:
  <T>Vec::operator=(m);
  nrows = m.nrows;
  ncols = m.ncols;
  return *this;
}

<A>GEMatrix&
<A>GEMatrix::operator=(<T> s)
{
  // Copy the base class over:
  <T>Vec::operator=(s);
  return *this;
}

<A>GEMatrix&
<A>GEMatrix::reference(<A>GEMatrix& m)
{
  <T>Vec::reference(m);
  nrows = m.nrows;
  ncols = m.ncols;
  return *this;
}

<A>GEMatrix
<A>GEMatrix::deepCopy()
{
  return <A>GEMatrix(<T>Vec::deepCopy(), nrows, ncols);
}

void
<A>GEMatrix::resize(unsigned M, unsigned N)
{
  if (M == nrows) {
    ncols = N;
    <T>Vec::resize(M*N);
  }
  else {
    <A>GEMatrix olddata(*this);
    int copyColLen = min( int(M), int(nrows) );
    int copyNumCols = min( int(N), int(ncols) );
    nrows = M;
    ncols = N;
    <T>Vec::resize(M*N);
    deepenShallowCopy();	// Make sure we're not sharing the data
    (*this) = <T>(0);
    for( int i=0; i<copyNumCols; i++ ) { // Copy over matrix column by column
      <T>Vec::slice(M*i,copyColLen) = olddata.col(i).slice(0,copyColLen);
    }
  }
}
